/*
 * Decompiled with CFR 0.152.
 */
package org.mule.construct;

import org.mule.DefaultMuleEvent;
import org.mule.RequestContext;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorChainBuilder;
import org.mule.api.processor.ProcessingStrategy;
import org.mule.construct.AbstractPipeline;
import org.mule.construct.flow.DefaultFlowProcessingStrategy;
import org.mule.construct.processor.FlowConstructStatisticsMessageProcessor;
import org.mule.interceptor.ProcessingTimeInterceptor;
import org.mule.lifecycle.processor.ProcessIfStartedMessageProcessor;
import org.mule.management.stats.FlowConstructStatistics;
import org.mule.processor.strategy.AsynchronousProcessingStrategy;
import org.mule.routing.requestreply.ReplyToPropertyRequestReplyReplier;
import org.mule.session.DefaultMuleSession;

public class Flow
extends AbstractPipeline
implements MessageProcessor {
    private int stageCount = 0;
    private int asyncCount = 0;

    public Flow(String name, MuleContext muleContext) {
        super(name, muleContext);
        this.processingStrategy = new DefaultFlowProcessingStrategy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        DefaultMuleSession calledSession = new DefaultMuleSession(event.getSession(), this);
        DefaultMuleEvent newEvent = new DefaultMuleEvent(event.getMessage(), event, (MuleSession)calledSession);
        RequestContext.setEvent(newEvent);
        try {
            MuleEvent result = this.pipeline.process(newEvent);
            if (result != null) {
                result.getMessage().release();
            }
            MuleEvent muleEvent = result;
            return muleEvent;
        }
        catch (Exception e) {
            MuleEvent muleEvent = this.getExceptionListener().handleException(e, newEvent);
            return muleEvent;
        }
        finally {
            RequestContext.setEvent(event);
            event.getMessage().release();
        }
    }

    @Override
    protected void configurePreProcessors(MessageProcessorChainBuilder builder) throws MuleException {
        super.configurePreProcessors(builder);
        builder.chain(new ProcessIfStartedMessageProcessor(this, this.getLifecycleState()));
        builder.chain(new ProcessingTimeInterceptor());
        builder.chain(new FlowConstructStatisticsMessageProcessor());
    }

    @Override
    protected void configurePostProcessors(MessageProcessorChainBuilder builder) throws MuleException {
        super.configurePostProcessors(builder);
        builder.chain(new ReplyToPropertyRequestReplyReplier());
    }

    @Deprecated
    public void setEndpoint(InboundEndpoint endpoint) {
        this.messageSource = endpoint;
    }

    @Override
    public String getConstructType() {
        return "Flow";
    }

    @Override
    protected void configureStatistics() {
        this.statistics = this.processingStrategy instanceof AsynchronousProcessingStrategy && ((AsynchronousProcessingStrategy)this.processingStrategy).getMaxThreads() != null ? new FlowConstructStatistics(this.getConstructType(), this.name, ((AsynchronousProcessingStrategy)this.processingStrategy).getMaxThreads()) : new FlowConstructStatistics(this.getConstructType(), this.name);
        this.statistics.setEnabled(this.muleContext.getStatistics().isEnabled());
        this.muleContext.getStatistics().add(this.statistics);
    }

    @Override
    protected void configureMessageProcessors(MessageProcessorChainBuilder builder) throws MuleException {
        this.getProcessingStrategy().configureProcessors(this.getMessageProcessors(), new ProcessingStrategy.StageNameSource(){

            @Override
            public String getName() {
                return String.format("%s.stage%s", Flow.this.getName(), ++Flow.this.stageCount);
            }
        }, builder, this.muleContext);
    }

    public ProcessingStrategy.StageNameSource getAsyncStageNameSource() {
        return new ProcessingStrategy.StageNameSource(){

            @Override
            public String getName() {
                return String.format("%s.async%s", Flow.this.getName(), ++Flow.this.asyncCount);
            }
        };
    }

    public ProcessingStrategy.StageNameSource getAsyncStageNameSource(final String asyncName) {
        return new ProcessingStrategy.StageNameSource(){

            @Override
            public String getName() {
                return String.format("%s.%s", Flow.this.getName(), asyncName);
            }
        };
    }
}

