/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.processor;

import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.routing.OutboundRouterCollection;
import org.mule.api.service.Service;
import org.mule.component.simple.PassThroughComponent;
import org.mule.processor.AbstractInterceptingMessageProcessor;
import org.mule.transport.NullPayload;

public class ServiceOutboundMessageProcessor
extends AbstractInterceptingMessageProcessor {
    protected Service service;

    public ServiceOutboundMessageProcessor(Service service) {
        this.service = service;
    }

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        boolean syncNullPayload;
        boolean bl = syncNullPayload = event.getExchangePattern().hasResponse() && event.getMessage().getPayload() instanceof NullPayload;
        if (event.isStopFurtherProcessing()) {
            this.logger.debug((Object)"MuleEvent stop further processing has been set, no outbound routing will be performed.");
            return event;
        }
        if (event != null && !syncNullPayload) {
            if (!(this.service.getOutboundMessageProcessor() instanceof OutboundRouterCollection) || this.service.getOutboundMessageProcessor() instanceof OutboundRouterCollection && ((OutboundRouterCollection)this.service.getOutboundMessageProcessor()).hasEndpoints()) {
                MuleEvent outboundEvent = event.getExchangePattern().hasResponse() ? new DefaultMuleEvent(new DefaultMuleMessage(event.getMessage().getPayload(), event.getMessage(), event.getMuleContext()), event) : event;
                MuleEvent outboundResult = this.processNext(outboundEvent);
                if (outboundResult != null) {
                    event = outboundResult;
                } else if (this.service.getComponent() instanceof PassThroughComponent) {
                    event = new DefaultMuleEvent(new DefaultMuleMessage((Object)NullPayload.getInstance(), event.getMessage(), this.service.getMuleContext()), event);
                }
            } else {
                this.logger.debug((Object)("Outbound router on service '" + this.service.getName() + "' doesn't have any targets configured."));
            }
        }
        return event;
    }
}

