/*
 * Decompiled with CFR 0.152.
 */
package org.ibeans.impl;

import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ibeans.api.AbstractCallInterceptor;
import org.ibeans.api.CallException;
import org.ibeans.api.IBeansException;
import org.ibeans.api.InvocationContext;
import org.ibeans.api.Response;
import org.ibeans.impl.support.util.Utils;
import org.ibeans.spi.ErrorFilter;
import org.ibeans.spi.Filter;
import org.w3c.dom.Document;

final class ProcessErrorsInterceptor
extends AbstractCallInterceptor {
    protected final transient Log logger = LogFactory.getLog(ProcessErrorsInterceptor.class);

    ProcessErrorsInterceptor() {
    }

    public void afterCall(InvocationContext invocationContext) throws Exception {
        Response response = invocationContext.getResponse();
        if (this.isErrorReply(invocationContext)) {
            String msg = response.getPayload() instanceof Document ? this.prettyPrint((Document)response.getPayload()) : response.getPayload().toString();
            CallException e = ProcessErrorsInterceptor.createCallException(invocationContext, new IBeansException(msg));
            if (invocationContext.getExceptionListener() != null) {
                invocationContext.getExceptionListener().exceptionThrown(e);
            } else {
                throw e;
            }
        }
    }

    private String prettyPrint(Document document) throws IOException {
        StringWriter stringWriter = new StringWriter();
        XMLSerializer serializer = new XMLSerializer(stringWriter, new OutputFormat("xml", "UTF-8", true));
        serializer.serialize(document);
        return stringWriter.toString();
    }

    protected boolean isErrorReply(InvocationContext context) throws IBeansException {
        if (context.getMethod().getName().startsWith("ibean")) {
            return false;
        }
        Response response = context.getResponse();
        Object finalResult = context.getResult();
        if (finalResult == null || finalResult.equals("")) {
            return false;
        }
        String mime = response.getMimeType();
        Filter f = context.getIBeanDefaultConfig().getMethodLevelErrorFilters().get(context.getMethod());
        if (f == null) {
            f = context.getIBeanDefaultConfig().getErrorFilters().get(mime);
        }
        if (f == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No matching error filter for Mime Type: " + mime));
            }
            return false;
        }
        return f.accept(response);
    }

    public static CallException createCallException(InvocationContext context, Throwable t) {
        if (t instanceof InvocationTargetException || t instanceof UndeclaredThrowableException) {
            t = t.getCause();
        }
        ErrorFilter filter = null;
        Response response = context.getResponse();
        if (response != null) {
            String mime = response.getMimeType();
            filter = context.getIBeanDefaultConfig().getErrorFilters().get(mime);
        }
        Object errorCode = null;
        Throwable root = t;
        while (root.getCause() != null) {
            root = root.getCause();
        }
        if (filter != null && filter.getErrorCodeExpression() != null && (errorCode = context.getExpressionParser().evaluate(filter.getType(), filter.getErrorCodeExpression(), response)) != null && !Utils.isNumeric(errorCode.toString())) {
            errorCode = null;
        }
        if (errorCode == null && response != null) {
            String statusCodeName = "http.status";
            errorCode = response.getHeader(statusCodeName);
        }
        if (errorCode != null) {
            errorCode = errorCode.toString();
        }
        CallException ce = new CallException(t.getMessage(), (String)errorCode, root);
        if (response != null) {
            for (String name : response.getHeaderNames()) {
                ce.getInfo().put(name, response.getHeader(name));
            }
            try {
                ce.getInfo().put("response.payload", response.getPayload());
            }
            catch (Exception e1) {
                ce.getInfo().put("exception.handler.error", e1.getMessage());
            }
        }
        return ce;
    }
}

