/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.util.Arrays;
import java.util.Comparator;
import org.drools.reteoo.AlphaNode;
import org.drools.reteoo.BetaNode;
import org.drools.reteoo.CompositeObjectSinkAdapter;
import org.drools.reteoo.LeftInputAdapterNode;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSinkNode;
import org.drools.reteoo.ObjectSinkNodeList;
import org.drools.reteoo.ObjectSinkPropagator;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.SingleObjectSinkAdapter;
import org.drools.util.Iterator;
import org.drools.util.ObjectHashMap;

public class AlphaNetworkCompiler {
    private StringBuilder builder;

    public void compile(ObjectTypeNode objectTypeNode) {
        this.builder = new StringBuilder();
        this.builder.append("public class Compiled" + objectTypeNode.getObjectType() + "AlphaNetwork implements ObjectSink { \n");
        this.createVars(objectTypeNode.getSinkPropagator().getSinks(), 4);
        this.builder.append("    public void assertObject(....) { \n");
        this.compileAlphaNodes(objectTypeNode.getSinkPropagator(), 8);
        this.builder.append("    } \n");
        this.builder.append("} \n");
        System.out.println(this.builder.toString());
    }

    public void createVars(ObjectSink[] sinks, int indent) {
        for (ObjectSink sink : sinks) {
            if (sink instanceof AlphaNode) {
                AlphaNode alphaNode = (AlphaNode)sink;
                this.builder.append(this.getIndent(indent) + "AlphaNodeFieldConstraint alphaNodeConstraint" + alphaNode.getId() + ";\n");
                this.createVars(alphaNode.getSinkPropagator().getSinks(), indent);
                continue;
            }
            if (sink instanceof BetaNode) {
                BetaNode betaNode = (BetaNode)sink;
                this.builder.append(this.getIndent(indent) + "ObjectSink sink" + betaNode.getId() + ";\n");
                continue;
            }
            if (!(sink instanceof LeftInputAdapterNode)) continue;
            LeftInputAdapterNode liaNode = (LeftInputAdapterNode)sink;
            this.builder.append(this.getIndent(indent) + "ObjectSink sink" + liaNode.getId() + ";\n");
        }
    }

    public void compileAlphaNodes(ObjectSinkPropagator adapter, int indent) {
        if (adapter instanceof SingleObjectSinkAdapter) {
            this.compileAlphaNodeSingleConstraint((SingleObjectSinkAdapter)adapter, indent);
        } else if (adapter instanceof CompositeObjectSinkAdapter) {
            this.compileAlphaNodeCompositeConstraint((CompositeObjectSinkAdapter)adapter, indent);
        }
    }

    private void compileAlphaNodeCompositeConstraint(CompositeObjectSinkAdapter adapter, int indent) {
        ObjectHashMap map;
        ObjectSinkNode sink;
        ObjectSinkNodeList sinks = adapter.getHashableSinks();
        if (sinks != null) {
            for (sink = sinks.getFirst(); sink != null; sink = sink.getNextObjectSinkNode()) {
                this.compileAlphaNodeSingleConstraint(sink, indent);
            }
        }
        if ((sinks = adapter.getOthers()) != null) {
            for (sink = sinks.getFirst(); sink != null; sink = sink.getNextObjectSinkNode()) {
                this.compileAlphaNodeSingleConstraint(sink, indent);
            }
        }
        if ((map = adapter.getHashedSinkMap()) != null) {
            ObjectHashMap.ObjectEntry[] entries = new ObjectHashMap.ObjectEntry[map.size()];
            Iterator it = map.iterator();
            int i = 0;
            ObjectHashMap.ObjectEntry entry = (ObjectHashMap.ObjectEntry)it.next();
            while (entry != null) {
                entries[i++] = entry;
                entry = (ObjectHashMap.ObjectEntry)it.next();
            }
            Arrays.sort(entries, new Comparator(){

                public int compare(Object o1, Object o2) {
                    ObjectHashMap.ObjectEntry entry1 = (ObjectHashMap.ObjectEntry)o1;
                    ObjectHashMap.ObjectEntry entry2 = (ObjectHashMap.ObjectEntry)o2;
                    return ((ObjectSink)entry1.getValue()).getId() - ((ObjectSink)entry2.getValue()).getId();
                }
            });
            this.builder.append(this.getIndent(indent) + "HashKey key = new HashKey(handle);\n");
            this.builder.append(this.getIndent(indent) + "swtich ((ObjectSink)this.hashedSinkedMap(key)).getId() {\n");
            for (ObjectHashMap.ObjectEntry entry2 : entries) {
                ObjectSink sink2 = (ObjectSink)entry2.getValue();
                this.builder.append(this.getIndent(indent + 4) + "case " + sink2.getId() + ": {\n");
                if (sink2 instanceof AlphaNode) {
                    this.compileAlphaNodes(((AlphaNode)sink2).getSinkPropagator(), indent + 8);
                }
                this.builder.append(this.getIndent(indent + 4) + "};\n");
            }
            this.builder.append(this.getIndent(indent) + "};\n");
        }
    }

    public void compileAlphaNodeSingleConstraint(SingleObjectSinkAdapter adapter, int indent) {
        this.compileAlphaNodeSingleConstraint(adapter.getSinks()[0], indent);
    }

    public void compileAlphaNodeSingleConstraint(ObjectSink sink, int indent) {
        if (sink instanceof AlphaNode) {
            AlphaNode alphaNode = (AlphaNode)sink;
            this.builder.append(this.getIndent(indent) + "if ( alphaNodeConstraint" + alphaNode.getId() + ".isAllowed(handle, wm) ) {\n");
            this.compileAlphaNodes(alphaNode.getSinkPropagator(), indent + 4);
            this.builder.append(this.getIndent(indent) + "}\n");
        } else if (sink instanceof BetaNode) {
            BetaNode betaNode = (BetaNode)sink;
            this.builder.append(this.getIndent(indent) + "sink" + betaNode.getId() + ".assertRight(handle, wm, context);\n");
        } else if (sink instanceof LeftInputAdapterNode) {
            LeftInputAdapterNode liaNode = (LeftInputAdapterNode)sink;
            this.builder.append(this.getIndent(indent) + "sink" + liaNode.getId() + ".assertRight(handle, wm, context);\n");
        }
    }

    public void compileAlphaNodeCompositeConstraint(ObjectSink sink, int indent) {
        if (sink instanceof AlphaNode) {
            AlphaNode alphaNode = (AlphaNode)sink;
            this.builder.append(this.getIndent(indent) + "if ( alphaNodeConstraint" + alphaNode.getId() + ".isAllowed(handle, wm) ) {\n");
            this.compileAlphaNodes(alphaNode.getSinkPropagator(), indent + 4);
            this.builder.append(this.getIndent(indent) + "}\n");
        } else if (sink instanceof BetaNode) {
            BetaNode betaNode = (BetaNode)sink;
            this.builder.append(this.getIndent(indent) + "sink" + betaNode.getId() + ".assertRight(handle, wm, context);\n");
        } else if (sink instanceof LeftInputAdapterNode) {
            LeftInputAdapterNode liaNode = (LeftInputAdapterNode)sink;
            this.builder.append(this.getIndent(indent) + "sink" + liaNode.getId() + ".assertRight(handle, wm, context);\n");
        }
    }

    private String getIndent(int indent) {
        char[] spaces = new char[indent];
        for (int i = 0; i < spaces.length; ++i) {
            spaces[i] = 32;
        }
        return new String(spaces);
    }
}

