/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workflow.instance.node;

import java.util.HashMap;
import java.util.Map;
import org.drools.common.InternalRuleBase;
import org.drools.process.core.Process;
import org.drools.process.instance.ProcessInstance;
import org.drools.process.instance.context.variable.VariableScopeInstance;
import org.drools.runtime.process.EventListener;
import org.drools.runtime.process.NodeInstance;
import org.drools.workflow.core.node.SubProcessNode;
import org.drools.workflow.instance.impl.NodeInstanceResolverFactory;
import org.drools.workflow.instance.impl.VariableScopeResolverFactory;
import org.drools.workflow.instance.node.EventBasedNodeInstance;
import org.mvel2.MVEL;
import org.mvel2.integration.VariableResolverFactory;

public class SubProcessNodeInstance
extends EventBasedNodeInstance
implements EventListener {
    private static final long serialVersionUID = 400L;
    private long processInstanceId;

    protected SubProcessNode getSubProcessNode() {
        return (SubProcessNode)this.getNode();
    }

    public void internalTrigger(NodeInstance from, String type) {
        super.internalTrigger(from, type);
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("A SubProcess node only accepts default incoming connections!");
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (Map.Entry<String, String> mapping : this.getSubProcessNode().getInMappings().entrySet()) {
            Object parameterValue = null;
            VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.resolveContextInstance("VariableScope", mapping.getValue());
            if (variableScopeInstance != null) {
                parameterValue = variableScopeInstance.getVariable(mapping.getValue());
            } else {
                try {
                    parameterValue = MVEL.eval((String)mapping.getValue(), (VariableResolverFactory)new NodeInstanceResolverFactory(this));
                }
                catch (Throwable t) {
                    System.err.println("Could not find variable scope for variable " + mapping.getValue());
                    System.err.println("when trying to execute SubProcess node " + this.getSubProcessNode().getName());
                    System.err.println("Continuing without setting parameter.");
                }
            }
            if (parameterValue == null) continue;
            parameters.put(mapping.getKey(), parameterValue);
        }
        String processId = this.getSubProcessNode().getProcessId();
        Process process = ((InternalRuleBase)this.getProcessInstance().getWorkingMemory().getRuleBase()).getProcess(processId);
        if (process == null) {
            System.err.println("Could not find process " + processId);
            System.err.println("Aborting process");
            this.getProcessInstance().setState(3);
        } else {
            ProcessInstance processInstance = this.getProcessInstance().getWorkingMemory().startProcess(processId, parameters);
            if (!this.getSubProcessNode().isWaitForCompletion() || processInstance.getState() == 2) {
                this.triggerCompleted();
            } else {
                this.processInstanceId = processInstance.getId();
                this.addProcessListener();
            }
        }
    }

    public void cancel() {
        ProcessInstance processInstance;
        super.cancel();
        if (!this.getSubProcessNode().isIndependent() && (processInstance = this.getProcessInstance().getWorkingMemory().getProcessInstance(this.processInstanceId)) != null) {
            processInstance.setState(3);
        }
    }

    public long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void internalSetProcessInstanceId(long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public void addEventListeners() {
        super.addEventListeners();
        this.addProcessListener();
    }

    private void addProcessListener() {
        this.getProcessInstance().addEventListener("processInstanceCompleted:" + this.processInstanceId, this, true);
    }

    public void removeEventListeners() {
        super.removeEventListeners();
        this.getProcessInstance().removeEventListener("processInstanceCompleted:" + this.processInstanceId, this, true);
    }

    public void signalEvent(String type, Object event) {
        if (("processInstanceCompleted:" + this.processInstanceId).equals(type)) {
            this.processInstanceCompleted((ProcessInstance)event);
        } else {
            super.signalEvent(type, event);
        }
    }

    public String[] getEventTypes() {
        return new String[]{"processInstanceCompleted:" + this.processInstanceId};
    }

    public void processInstanceCompleted(ProcessInstance processInstance) {
        this.removeEventListeners();
        VariableScopeInstance subProcessVariableScopeInstance = (VariableScopeInstance)processInstance.getContextInstance("VariableScope");
        for (Map.Entry<String, String> mapping : this.getSubProcessNode().getOutMappings().entrySet()) {
            VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.resolveContextInstance("VariableScope", mapping.getValue());
            if (variableScopeInstance != null) {
                Object value = subProcessVariableScopeInstance.getVariable(mapping.getKey());
                if (value == null) {
                    try {
                        value = MVEL.eval((String)mapping.getKey(), (VariableResolverFactory)new VariableScopeResolverFactory(subProcessVariableScopeInstance));
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                variableScopeInstance.setVariable(mapping.getValue(), value);
                continue;
            }
            System.err.println("Could not find variable scope for variable " + mapping.getValue());
            System.err.println("when trying to complete SubProcess node " + this.getSubProcessNode().getName());
            System.err.println("Continuing without setting variable.");
        }
        this.triggerCompleted();
    }
}

