/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.Err;
import net.sf.saxon.expr.CardinalityChecker;
import net.sf.saxon.expr.ContextMappingFunction;
import net.sf.saxon.expr.ContextMappingIterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.FirstItemExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.PatternSponsor;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.sort.GroupAdjacentIterator;
import net.sf.saxon.sort.GroupByIterator;
import net.sf.saxon.sort.GroupEndingIterator;
import net.sf.saxon.sort.GroupIterator;
import net.sf.saxon.sort.GroupStartingIterator;
import net.sf.saxon.sort.SortKeyDefinition;
import net.sf.saxon.sort.SortKeyEvaluator;
import net.sf.saxon.sort.SortedGroupIterator;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.trace.TraceListener;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.StringValue;

public class ForEachGroup
extends Instruction
implements ContextMappingFunction,
SortKeyEvaluator {
    public static final int GROUP_BY = 0;
    public static final int GROUP_ADJACENT = 1;
    public static final int GROUP_STARTING = 2;
    public static final int GROUP_ENDING = 3;
    private Expression select;
    private Expression action;
    private byte algorithm;
    private Expression key;
    private Expression collationNameExpression;
    private String baseURI;
    private StringCollator collator = null;
    private SortKeyDefinition[] sortKeys = null;
    private transient AtomicComparer[] sortComparators = null;

    public ForEachGroup(Expression expression, Expression expression2, byte by, Expression expression3, StringCollator stringCollator, Expression expression4, String string, SortKeyDefinition[] sortKeyDefinitionArray) {
        this.select = expression;
        this.action = expression2;
        this.algorithm = by;
        this.key = expression3;
        this.collator = stringCollator;
        this.collationNameExpression = expression4;
        this.baseURI = string;
        this.sortKeys = sortKeyDefinitionArray;
        Iterator iterator = this.iterateSubExpressions();
        while (iterator.hasNext()) {
            Expression expression5 = (Expression)iterator.next();
            this.adoptChildExpression(expression5);
        }
    }

    public int getInstructionNameCode() {
        return 148;
    }

    public Expression getActionExpression() {
        return this.action;
    }

    public Expression getGroupingKey() {
        return this.key;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.select = this.select.simplify(staticContext);
        this.action = this.action.simplify(staticContext);
        this.key = this.key.simplify(staticContext);
        return this;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        TypeHierarchy typeHierarchy = staticContext.getConfiguration().getTypeHierarchy();
        this.select = this.select.typeCheck(staticContext, itemType);
        ItemType itemType2 = this.select.getItemType(typeHierarchy);
        this.action = this.action.typeCheck(staticContext, itemType2);
        this.key = this.key.typeCheck(staticContext, itemType2);
        if (Literal.isEmptySequence(this.select)) {
            return this.select;
        }
        if (Literal.isEmptySequence(this.action)) {
            return this.action;
        }
        if (this.sortKeys != null) {
            int n;
            boolean bl = true;
            for (n = 0; n < this.sortKeys.length; ++n) {
                Serializable serializable;
                Expression expression = this.sortKeys[n].getSortKey();
                expression = expression.typeCheck(staticContext, itemType2);
                if (staticContext.isInBackwardsCompatibleMode()) {
                    expression = new FirstItemExpression(expression);
                } else {
                    serializable = new RoleLocator(4, "xsl:sort/select", 0, null);
                    serializable.setErrorCode("XTTE1020");
                    expression = CardinalityChecker.makeCardinalityChecker(expression, 24576, serializable);
                }
                this.sortKeys[n].setSortKey(expression);
                if (this.sortKeys[n].isFixed()) {
                    serializable = this.sortKeys[n].makeComparator(staticContext.makeEarlyEvaluationContext());
                    this.sortKeys[n].setFinalComparator((AtomicComparer)serializable);
                    continue;
                }
                bl = false;
            }
            if (bl) {
                this.sortComparators = new AtomicComparer[this.sortKeys.length];
                for (n = 0; n < this.sortKeys.length; ++n) {
                    this.sortComparators[n] = this.sortKeys[n].getFinalComparator();
                }
            }
        }
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        TypeHierarchy typeHierarchy = staticContext.getConfiguration().getTypeHierarchy();
        this.select = this.select.optimize(optimizer, staticContext, itemType);
        this.action = this.action.optimize(optimizer, staticContext, this.select.getItemType(typeHierarchy));
        this.key = this.key.optimize(optimizer, staticContext, this.select.getItemType(typeHierarchy));
        this.adoptChildExpression(this.select);
        this.adoptChildExpression(this.action);
        this.adoptChildExpression(this.key);
        if (Literal.isEmptySequence(this.select)) {
            return this.select;
        }
        if (Literal.isEmptySequence(this.action)) {
            return this.action;
        }
        if (this.collator == null && this.collationNameExpression instanceof StringLiteral) {
            String string = ((StringLiteral)this.collationNameExpression).getStringValue();
            try {
                URI uRI = new URI(string);
                if (!uRI.isAbsolute()) {
                    URI uRI2 = new URI(this.baseURI);
                    uRI = uRI2.resolve(uRI);
                    String string2 = uRI.toString();
                    this.collationNameExpression = new StringLiteral(string2);
                    this.collator = staticContext.getCollation(string2);
                    if (this.collator == null) {
                        StaticError staticError = new StaticError("Unknown collation " + Err.wrap(uRI.toString(), 7));
                        staticError.setErrorCode("XTDE1110");
                        staticError.setLocator(this);
                        throw staticError;
                    }
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                StaticError staticError = new StaticError("Collation name '" + this.collationNameExpression + "' is not a valid URI");
                staticError.setErrorCode("XTDE1110");
                staticError.setLocator(this);
                throw staticError;
            }
        }
        return this;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return this.action.getItemType(typeHierarchy);
    }

    public int computeDependencies() {
        int n = 0;
        n |= this.select.getDependencies();
        n |= this.key.getDependencies() & 0xFFFFFFE1;
        n |= this.action.getDependencies() & 0xFFFFFFC1;
        if (this.sortKeys != null) {
            for (int i = 0; i < this.sortKeys.length; ++i) {
                n |= this.sortKeys[i].getSortKey().getDependencies() & 0xFFFFFFE1;
                Expression expression = this.sortKeys[i].getCaseOrder();
                if (expression != null && !(expression instanceof Literal)) {
                    n |= expression.getDependencies();
                }
                if ((expression = this.sortKeys[i].getDataTypeExpression()) != null && !(expression instanceof Literal)) {
                    n |= expression.getDependencies();
                }
                if ((expression = this.sortKeys[i].getLanguage()) == null || expression instanceof Literal) continue;
                n |= expression.getDependencies();
            }
        }
        if (this.collationNameExpression != null) {
            n |= this.collationNameExpression.getDependencies();
        }
        return n;
    }

    public final boolean createsNewNodes() {
        int n = this.action.getSpecialProperties();
        return (n & 0x400000) == 0;
    }

    protected void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        this.select = this.doPromotion(this.select, promotionOffer);
        this.action = this.doPromotion(this.action, promotionOffer);
        this.key = this.doPromotion(this.key, promotionOffer);
    }

    public Iterator iterateSubExpressions() {
        ArrayList<Expression> arrayList = new ArrayList<Expression>(8);
        arrayList.add(this.select);
        arrayList.add(this.action);
        arrayList.add(this.key);
        if (this.collationNameExpression != null) {
            arrayList.add(this.collationNameExpression);
        }
        if (this.sortKeys != null) {
            for (int i = 0; i < this.sortKeys.length; ++i) {
                arrayList.add(this.sortKeys[i].getSortKey());
                Expression expression = this.sortKeys[i].getOrder();
                if (expression != null) {
                    arrayList.add(expression);
                }
                if ((expression = this.sortKeys[i].getCaseOrder()) != null) {
                    arrayList.add(expression);
                }
                if ((expression = this.sortKeys[i].getDataTypeExpression()) != null) {
                    arrayList.add(expression);
                }
                if ((expression = this.sortKeys[i].getLanguage()) != null) {
                    arrayList.add(expression);
                }
                if ((expression = this.sortKeys[i].getCollationNameExpression()) == null) continue;
                arrayList.add(expression);
            }
        }
        return arrayList.iterator();
    }

    public boolean replaceSubExpression(Expression expression, Expression expression2) {
        boolean bl = false;
        if (this.select == expression) {
            this.select = expression2;
            bl = true;
        }
        if (this.action == expression) {
            this.action = expression2;
            bl = true;
        }
        if (this.collationNameExpression == expression) {
            this.collationNameExpression = expression2;
            bl = true;
        }
        if (this.key == expression) {
            this.key = expression2;
            bl = true;
        }
        if (this.sortKeys != null) {
            for (int i = 0; i < this.sortKeys.length; ++i) {
                if (this.sortKeys[i].getSortKey() == expression) {
                    this.sortKeys[i].setSortKey(expression2);
                    bl = true;
                }
                if (this.sortKeys[i].getOrder() == expression) {
                    this.sortKeys[i].setOrder(expression2);
                    bl = true;
                }
                if (this.sortKeys[i].getCaseOrder() == expression) {
                    this.sortKeys[i].setCaseOrder(expression2);
                    bl = true;
                }
                if (this.sortKeys[i].getDataTypeExpression() == expression) {
                    this.sortKeys[i].setDataTypeExpression(expression2);
                    bl = true;
                }
                if (this.sortKeys[i].getLanguage() != expression) continue;
                this.sortKeys[i].setLanguage(expression2);
                bl = true;
            }
        }
        return bl;
    }

    public void checkPermittedContents(SchemaType schemaType, StaticContext staticContext, boolean bl) throws XPathException {
        this.action.checkPermittedContents(schemaType, staticContext, false);
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        Controller controller = xPathContext.getController();
        GroupIterator groupIterator = this.getGroupIterator(xPathContext);
        XPathContextMajor xPathContextMajor = xPathContext.newContext();
        xPathContextMajor.setOrigin(this);
        xPathContextMajor.setCurrentIterator(groupIterator);
        xPathContextMajor.setCurrentGroupIterator(groupIterator);
        xPathContextMajor.setCurrentTemplateRule(null);
        if (controller.isTracing()) {
            Item item;
            TraceListener traceListener = controller.getTraceListener();
            while ((item = groupIterator.next()) != null) {
                traceListener.startCurrentItem(item);
                this.action.process(xPathContextMajor);
                traceListener.endCurrentItem(item);
            }
        } else {
            Item item;
            while ((item = groupIterator.next()) != null) {
                this.action.process(xPathContextMajor);
            }
        }
        return null;
    }

    private StringCollator getCollator(XPathContext xPathContext) throws XPathException {
        if (this.collationNameExpression != null) {
            StringValue stringValue = (StringValue)this.collationNameExpression.evaluateItem(xPathContext);
            String string = stringValue.getStringValue();
            try {
                URI uRI = new URI(string);
                if (!uRI.isAbsolute()) {
                    if (this.baseURI == null) {
                        DynamicError dynamicError = new DynamicError("Cannot resolve relative collation URI '" + string + "': unknown or invalid base URI");
                        dynamicError.setErrorCode("XTDE1110");
                        dynamicError.setXPathContext(xPathContext);
                        dynamicError.setLocator(this);
                        throw dynamicError;
                    }
                    uRI = new URI(this.baseURI).resolve(uRI);
                    string = uRI.toString();
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                DynamicError dynamicError = new DynamicError("Collation name '" + string + "' is not a valid URI");
                dynamicError.setErrorCode("XTDE1110");
                dynamicError.setXPathContext(xPathContext);
                dynamicError.setLocator(this);
                throw dynamicError;
            }
            return xPathContext.getCollation(string);
        }
        StringCollator stringCollator = xPathContext.getDefaultCollation();
        return stringCollator == null ? CodepointCollator.getInstance() : stringCollator;
    }

    private GroupIterator getGroupIterator(XPathContext xPathContext) throws XPathException {
        GroupIterator groupIterator;
        XPathContextMinor xPathContextMinor;
        AtomicComparer[] atomicComparerArray;
        SequenceIterator sequenceIterator = this.select.iterate(xPathContext);
        switch (this.algorithm) {
            case 0: {
                atomicComparerArray = this.collator;
                if (atomicComparerArray == null) {
                    atomicComparerArray = this.getCollator(xPathContext);
                }
                xPathContextMinor = xPathContext.newMinorContext();
                xPathContextMinor.setOrigin(this);
                xPathContextMinor.setCurrentIterator(sequenceIterator);
                groupIterator = new GroupByIterator(sequenceIterator, this.key, xPathContextMinor, (StringCollator)atomicComparerArray);
                break;
            }
            case 1: {
                atomicComparerArray = this.collator;
                if (atomicComparerArray == null) {
                    atomicComparerArray = this.getCollator(xPathContext);
                }
                groupIterator = new GroupAdjacentIterator(sequenceIterator, this.key, xPathContext, (StringCollator)atomicComparerArray);
                break;
            }
            case 2: {
                groupIterator = new GroupStartingIterator(sequenceIterator, ((PatternSponsor)this.key).getPattern(), xPathContext);
                break;
            }
            case 3: {
                groupIterator = new GroupEndingIterator(sequenceIterator, ((PatternSponsor)this.key).getPattern(), xPathContext);
                break;
            }
            default: {
                throw new AssertionError((Object)"Unknown grouping algorithm");
            }
        }
        if (this.sortKeys != null) {
            atomicComparerArray = this.sortComparators;
            xPathContextMinor = xPathContext.newMinorContext();
            if (atomicComparerArray == null) {
                atomicComparerArray = new AtomicComparer[this.sortKeys.length];
                for (int i = 0; i < this.sortKeys.length; ++i) {
                    atomicComparerArray[i] = this.sortKeys[i].makeComparator(xPathContextMinor);
                }
            }
            groupIterator = new SortedGroupIterator(xPathContextMinor, groupIterator, this, atomicComparerArray, this);
        }
        return groupIterator;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        GroupIterator groupIterator = this.getGroupIterator(xPathContext);
        XPathContextMajor xPathContextMajor = xPathContext.newContext();
        xPathContextMajor.setOrigin(this);
        xPathContextMajor.setCurrentIterator(groupIterator);
        xPathContextMajor.setCurrentGroupIterator(groupIterator);
        xPathContextMajor.setCurrentTemplateRule(null);
        return new ContextMappingIterator(this, xPathContextMajor);
    }

    public SequenceIterator map(XPathContext xPathContext) throws XPathException {
        return this.action.iterate(xPathContext);
    }

    public Item evaluateSortKey(int n, XPathContext xPathContext) throws XPathException {
        return this.sortKeys[n].getSortKey().evaluateItem(xPathContext);
    }

    public void display(int n, PrintStream printStream, Configuration configuration) {
        printStream.println(ExpressionTool.indent(n) + "for-each-group");
        printStream.println(ExpressionTool.indent(n) + "select");
        this.select.display(n + 1, printStream, configuration);
        printStream.println(ExpressionTool.indent(n) + this.getAlgorithmName(this.algorithm));
        this.key.display(n + 1, printStream, configuration);
        printStream.println(ExpressionTool.indent(n) + "return");
        this.action.display(n + 1, printStream, configuration);
    }

    private String getAlgorithmName(byte by) {
        switch (by) {
            case 0: {
                return "group-by";
            }
            case 1: {
                return "group-adjacent";
            }
            case 2: {
                return "group-starting-with";
            }
            case 3: {
                return "group-ending-with";
            }
        }
        return "** unknown algorithm **";
    }
}

