/*
 * $Id: VoidResultTestCase.java 22377 2011-07-11 12:41:42Z dirk.olmes $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule;

import org.mule.tck.junit4.AbstractMuleTestCase;

import org.apache.commons.lang.SerializationUtils;
import org.junit.Test;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertSame;

public class VoidResultTestCase extends AbstractMuleTestCase
{

    @Test
    public void testUniqueDeserialization()
    {
        VoidResult result = VoidResult.getInstance();

        byte[] serialized = SerializationUtils.serialize(result);
        assertNotNull(serialized);

        Object deserialized = SerializationUtils.deserialize(serialized);
        assertSame(deserialized, result);
        assertEquals(deserialized, result);
    }

}
