/*
 * Decompiled with CFR 0.152.
 */
package org.mule.cache;

import java.io.Serializable;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.Filter;
import org.mule.api.store.ObjectStore;
import org.mule.cache.ObjectStoreCachingStrategy;
import org.mule.cache.keygenerator.KeyGenerator;
import org.mule.cache.responsegenerator.ResponseGenerator;
import org.mule.routing.filters.AcceptAllFilter;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class ObjectStoreCachingStrategyTestCase
extends AbstractMuleTestCase {
    private static final String OBJECT_KEY = "key";

    @Test
    public void testCacheMiss() throws Exception {
        MuleEvent mockEvent = (MuleEvent)Mockito.mock(MuleEvent.class);
        MuleEvent mockResponse = (MuleEvent)Mockito.mock(MuleEvent.class);
        KeyGenerator keyGenerator = (KeyGenerator)Mockito.mock(KeyGenerator.class);
        Mockito.when((Object)keyGenerator.generateKey(mockEvent)).thenReturn((Object)OBJECT_KEY);
        ObjectStore objectStore = (ObjectStore)Mockito.mock(ObjectStore.class);
        Mockito.when((Object)objectStore.retrieve((Serializable)((Object)OBJECT_KEY))).thenReturn(null);
        Filter consumablePayloadFilter = (Filter)Mockito.mock(Filter.class);
        Mockito.when((Object)consumablePayloadFilter.accept((MuleMessage)Mockito.any())).thenReturn((Object)true);
        ObjectStoreCachingStrategy cachingStrategy = new ObjectStoreCachingStrategy();
        cachingStrategy.setKeyGenerator(keyGenerator);
        cachingStrategy.setStore(objectStore);
        cachingStrategy.setConsumableFilter(consumablePayloadFilter);
        MessageProcessor cachedMessageProcessor = (MessageProcessor)Mockito.mock(MessageProcessor.class);
        Mockito.when((Object)cachedMessageProcessor.process(mockEvent)).thenReturn((Object)mockResponse);
        MuleEvent response = cachingStrategy.process(mockEvent, cachedMessageProcessor);
        Assert.assertSame((Object)mockResponse, (Object)response);
        ((ObjectStore)Mockito.verify((Object)objectStore, (VerificationMode)Mockito.times((int)1))).store((Serializable)((Object)OBJECT_KEY), (Serializable)mockResponse);
    }

    @Test
    public void testCacheHit() throws Exception {
        MuleEvent mockEvent = (MuleEvent)Mockito.mock(MuleEvent.class);
        MuleEvent mockResponse = (MuleEvent)Mockito.mock(MuleEvent.class);
        KeyGenerator keyGenerator = (KeyGenerator)Mockito.mock(KeyGenerator.class);
        Mockito.when((Object)keyGenerator.generateKey(mockEvent)).thenReturn((Object)OBJECT_KEY);
        ResponseGenerator responseGenerator = (ResponseGenerator)Mockito.mock(ResponseGenerator.class);
        Mockito.when((Object)responseGenerator.create(mockEvent, mockResponse)).thenReturn((Object)mockResponse);
        ObjectStore objectStore = (ObjectStore)Mockito.mock(ObjectStore.class);
        Mockito.when((Object)objectStore.retrieve((Serializable)((Object)OBJECT_KEY))).thenReturn((Object)mockResponse);
        ObjectStoreCachingStrategy cachingStrategy = new ObjectStoreCachingStrategy();
        cachingStrategy.setKeyGenerator(keyGenerator);
        cachingStrategy.setStore(objectStore);
        cachingStrategy.setResponseGenerator(responseGenerator);
        cachingStrategy.setConsumableFilter((Filter)new AcceptAllFilter());
        MessageProcessor cachedMessageProcessor = (MessageProcessor)Mockito.mock(MessageProcessor.class);
        MuleEvent response = cachingStrategy.process(mockEvent, cachedMessageProcessor);
        Assert.assertSame((Object)mockResponse, (Object)response);
        ((ObjectStore)Mockito.verify((Object)objectStore, (VerificationMode)Mockito.times((int)0))).store((Serializable)((Object)OBJECT_KEY), (Serializable)mockResponse);
        ((MessageProcessor)Mockito.verify((Object)cachedMessageProcessor, (VerificationMode)Mockito.times((int)0))).process(mockEvent);
    }

    @Test
    public void testConsumableRequestPayloadIsNotCached() throws Exception {
        MuleEvent mockEvent = (MuleEvent)Mockito.mock(MuleEvent.class);
        MuleEvent mockResponse = (MuleEvent)Mockito.mock(MuleEvent.class);
        ObjectStore objectStore = (ObjectStore)Mockito.mock(ObjectStore.class);
        Filter consumablePayloadFilter = (Filter)Mockito.mock(Filter.class);
        Mockito.when((Object)consumablePayloadFilter.accept((MuleMessage)Mockito.any())).thenReturn((Object)false);
        ObjectStoreCachingStrategy cachingStrategy = new ObjectStoreCachingStrategy();
        cachingStrategy.setStore(objectStore);
        cachingStrategy.setConsumableFilter(consumablePayloadFilter);
        MessageProcessor cachedMessageProcessor = (MessageProcessor)Mockito.mock(MessageProcessor.class);
        Mockito.when((Object)cachedMessageProcessor.process(mockEvent)).thenReturn((Object)mockResponse);
        MuleEvent response = cachingStrategy.process(mockEvent, cachedMessageProcessor);
        Assert.assertSame((Object)mockResponse, (Object)response);
        ((ObjectStore)Mockito.verify((Object)objectStore, (VerificationMode)Mockito.times((int)0))).retrieve((Serializable)mockEvent);
    }

    @Test
    public void testConsumableResponsePayloadIsNotCached() throws Exception {
        MuleEvent mockEvent = (MuleEvent)Mockito.mock(MuleEvent.class);
        MuleEvent mockResponse = (MuleEvent)Mockito.mock(MuleEvent.class);
        KeyGenerator keyGenerator = (KeyGenerator)Mockito.mock(KeyGenerator.class);
        Mockito.when((Object)keyGenerator.generateKey(mockEvent)).thenReturn((Object)OBJECT_KEY);
        ResponseGenerator responseGenerator = (ResponseGenerator)Mockito.mock(ResponseGenerator.class);
        Mockito.when((Object)responseGenerator.create(mockEvent, mockResponse)).thenReturn((Object)mockResponse);
        ObjectStore objectStore = (ObjectStore)Mockito.mock(ObjectStore.class);
        Filter consumablePayloadFilter = (Filter)Mockito.mock(Filter.class);
        Mockito.when((Object)consumablePayloadFilter.accept((MuleMessage)Mockito.any())).thenReturn((Object)true).thenReturn((Object)false);
        ObjectStoreCachingStrategy cachingStrategy = new ObjectStoreCachingStrategy();
        cachingStrategy.setKeyGenerator(keyGenerator);
        cachingStrategy.setResponseGenerator(responseGenerator);
        cachingStrategy.setStore(objectStore);
        cachingStrategy.setConsumableFilter(consumablePayloadFilter);
        MessageProcessor cachedMessageProcessor = (MessageProcessor)Mockito.mock(MessageProcessor.class);
        Mockito.when((Object)cachedMessageProcessor.process(mockEvent)).thenReturn((Object)mockResponse);
        MuleEvent response = cachingStrategy.process(mockEvent, cachedMessageProcessor);
        Assert.assertSame((Object)mockResponse, (Object)response);
        ((ObjectStore)Mockito.verify((Object)objectStore, (VerificationMode)Mockito.times((int)0))).store((Serializable)((Object)OBJECT_KEY), (Serializable)mockResponse);
    }
}

