/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint.inbound;

import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorChain;
import org.mule.endpoint.AbstractMessageProcessorTestCase;
import org.mule.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.tck.testmodels.mule.TestMessageProcessor;

public class InboundEndpointMessageProcessorsTestCase
extends AbstractMessageProcessorTestCase {
    private static final String TEST_MESSAGE = "test";
    private InboundEndpoint endpoint;
    private MuleMessage inMessage;
    private MuleEvent requestEvent;
    private MuleEvent result;

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.inMessage = this.createTestRequestMessage();
        this.endpoint = this.createTestInboundEndpoint(null, null, null, null, MessageExchangePattern.REQUEST_RESPONSE, null);
        this.requestEvent = this.createTestRequestEvent(this.endpoint);
    }

    @Test
    public void testProcessors() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new TestMessageProcessor("1"), new TestMessageProcessor("2"), new TestMessageProcessor("3")});
        MessageProcessorChain mpChain = builder.build();
        this.result = mpChain.process(this.requestEvent);
        Assert.assertEquals((Object)"test:1:2:3", (Object)this.result.getMessage().getPayload());
    }

    @Test
    public void testNoProcessors() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        MessageProcessorChain mpChain = builder.build();
        this.result = mpChain.process(this.requestEvent);
        Assert.assertEquals((Object)TEST_MESSAGE, (Object)this.result.getMessage().getPayload());
    }

    protected MuleMessage createTestRequestMessage() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("prop1", "value1");
        return new DefaultMuleMessage((Object)TEST_MESSAGE, props, muleContext);
    }

    protected MuleEvent createTestRequestEvent(InboundEndpoint endpoint) throws Exception {
        return new DefaultMuleEvent(this.inMessage, endpoint, InboundEndpointMessageProcessorsTestCase.getTestSession(InboundEndpointMessageProcessorsTestCase.getTestService(), muleContext));
    }
}

