/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint.outbound;

import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.mule.MessageExchangePattern;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.Filter;
import org.mule.api.security.SecurityFilter;
import org.mule.api.transaction.TransactionConfig;
import org.mule.api.transformer.Transformer;
import org.mule.api.transport.Connector;
import org.mule.api.transport.MessageDispatcher;
import org.mule.api.transport.MessageDispatcherFactory;
import org.mule.endpoint.AbstractMessageProcessorTestCase;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.tck.security.TestSecurityFilter;
import org.mule.tck.testmodels.mule.TestMessageDispatcher;
import org.mule.tck.testmodels.mule.TestMessageDispatcherFactory;
import org.mule.transformer.simple.OutboundAppendTransformer;
import org.mule.transformer.simple.ResponseAppendTransformer;
import org.mule.util.concurrent.Latch;

public class OutboundEndpointTestCase
extends AbstractMessageProcessorTestCase {
    protected FakeMessageDispatcher dispacher;
    protected MuleEvent testOutboundEvent;

    @Test
    public void testDefaultFlowSync() throws Exception {
        OutboundEndpoint endpoint = this.createOutboundEndpoint(null, null, null, null, MessageExchangePattern.REQUEST_RESPONSE, null);
        this.testOutboundEvent = this.createTestOutboundEvent();
        MuleEvent result = endpoint.process(this.testOutboundEvent);
        this.assertMessageSentSame(true);
        Assert.assertNotSame((Object)responseMessage, (Object)result.getMessage());
        this.assertMessageEqualEncodingPropertyAdded(responseMessage, result.getMessage());
    }

    @Test
    public void testDefaultFlowAsync() throws Exception {
        OutboundEndpoint endpoint = this.createOutboundEndpoint(null, null, null, null, MessageExchangePattern.ONE_WAY, null);
        this.testOutboundEvent = this.createTestOutboundEvent();
        MuleEvent result = endpoint.process(this.testOutboundEvent);
        this.dispacher.latch.await(5000L, TimeUnit.MILLISECONDS);
        this.assertMessageSentSame(false);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testSecurityFilterAccept() throws Exception {
        OutboundEndpoint endpoint = this.createOutboundEndpoint(null, (SecurityFilter)new TestSecurityFilter(true), null, null, MessageExchangePattern.REQUEST_RESPONSE, null);
        this.testOutboundEvent = this.createTestOutboundEvent();
        MuleEvent result = endpoint.process(this.testOutboundEvent);
        this.assertMessageSentSame(true);
        Assert.assertNotSame((Object)responseMessage, (Object)result.getMessage());
        this.assertMessageEqualEncodingPropertyAdded(responseMessage, result.getMessage());
    }

    @Test
    public void testSecurityFilterNotAccept() throws Exception {
        AbstractMessageProcessorTestCase.TestSecurityNotificationListener securityNotificationListener = new AbstractMessageProcessorTestCase.TestSecurityNotificationListener();
        muleContext.registerListener((ServerNotificationListener)securityNotificationListener);
        OutboundEndpoint endpoint = this.createOutboundEndpoint(null, (SecurityFilter)new TestSecurityFilter(false), null, null, MessageExchangePattern.REQUEST_RESPONSE, null);
        this.testOutboundEvent = this.createTestOutboundEvent();
        RequestContext.setEvent((MuleEvent)this.testOutboundEvent);
        try {
            endpoint.process(this.testOutboundEvent);
            Assert.fail((String)"Exception expected");
        }
        catch (TestSecurityFilter.StaticMessageUnauthorisedException e) {
            this.testOutboundEvent.getFlowConstruct().getExceptionListener().handleException((Exception)((Object)e), this.testOutboundEvent);
        }
        this.assertMessageNotSent();
        Assert.assertTrue((boolean)securityNotificationListener.latch.await(5000L, TimeUnit.MILLISECONDS));
        Assert.assertEquals((long)401L, (long)securityNotificationListener.securityNotification.getAction());
        Assert.assertEquals((Object)securityNotificationListener.securityNotification.getResourceIdentifier(), (Object)TestSecurityFilter.StaticMessageUnauthorisedException.class.getName());
    }

    @Test
    public void testSendNotfication() throws Exception {
        AbstractMessageProcessorTestCase.TestEndpointMessageNotificationListener listener = new AbstractMessageProcessorTestCase.TestEndpointMessageNotificationListener();
        muleContext.registerListener((ServerNotificationListener)listener);
        OutboundEndpoint endpoint = this.createOutboundEndpoint(null, null, null, null, MessageExchangePattern.REQUEST_RESPONSE, null);
        MuleEvent outboundEvent = this.createTestOutboundEvent();
        endpoint.process(outboundEvent);
        Assert.assertTrue((boolean)listener.latch.await(5000L, TimeUnit.MILLISECONDS));
        Assert.assertEquals((long)803L, (long)listener.messageNotification.getAction());
        Assert.assertEquals((Object)endpoint.getEndpointURI().getUri().toString(), (Object)listener.messageNotification.getEndpoint());
        Assert.assertTrue((boolean)(listener.messageNotification.getSource() instanceof MuleMessage));
        Assert.assertEquals((Object)outboundEvent.getMessage().getPayload(), (Object)listener.messageNotification.getSource().getPayload());
    }

    @Test
    public void testDispatchNotfication() throws Exception {
        AbstractMessageProcessorTestCase.TestEndpointMessageNotificationListener listener = new AbstractMessageProcessorTestCase.TestEndpointMessageNotificationListener();
        muleContext.registerListener((ServerNotificationListener)listener);
        OutboundEndpoint endpoint = this.createOutboundEndpoint(null, null, null, null, MessageExchangePattern.ONE_WAY, null);
        MuleEvent outboundEvent = this.createTestOutboundEvent();
        endpoint.process(outboundEvent);
        Assert.assertTrue((boolean)listener.latch.await(5000L, TimeUnit.MILLISECONDS));
        Assert.assertEquals((long)802L, (long)listener.messageNotification.getAction());
        Assert.assertEquals((Object)endpoint.getEndpointURI().getUri().toString(), (Object)listener.messageNotification.getEndpoint());
        Assert.assertTrue((boolean)(listener.messageNotification.getSource() instanceof MuleMessage));
        Assert.assertEquals((Object)outboundEvent.getMessage().getPayload(), (Object)listener.messageNotification.getSource().getPayload());
    }

    @Test
    public void testTransformers() throws Exception {
        OutboundEndpoint endpoint = this.createOutboundEndpoint(null, null, (Transformer)new OutboundAppendTransformer(), (Transformer)new ResponseAppendTransformer(), MessageExchangePattern.REQUEST_RESPONSE, null);
        MuleEvent outboundEvent = this.createTestOutboundEvent();
        MuleEvent result = endpoint.process(outboundEvent);
        this.assertMessageSent(true);
        Assert.assertEquals((Object)("Test Message" + OutboundAppendTransformer.APPEND_STRING), (Object)this.dispacher.sensedSendEvent.getMessageAsString());
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)(RESPONSE_MESSAGE + ResponseAppendTransformer.APPEND_STRING), (Object)result.getMessageAsString());
    }

    @Test
    public void testConnectorNotStarted() throws Exception {
        OutboundEndpoint endpoint = this.createOutboundEndpoint(null, null, null, null, MessageExchangePattern.REQUEST_RESPONSE, null);
        this.testOutboundEvent = this.createTestOutboundEvent();
        endpoint.getConnector().stop();
        try {
            endpoint.process(this.testOutboundEvent);
            Assert.fail((String)"Exception expected");
        }
        catch (LifecycleException lifecycleException) {
            // empty catch block
        }
    }

    @Test
    public void testTimeoutSetOnEvent() throws Exception {
        int testTimeout = 999;
        OutboundEndpoint endpoint = this.createOutboundEndpoint(null, null, null, null, MessageExchangePattern.REQUEST_RESPONSE, null);
        this.testOutboundEvent = this.createTestOutboundEvent();
        this.testOutboundEvent.getMessage().setOutboundProperty("MULE_EVENT_TIMEOUT", (Object)testTimeout);
        endpoint.process(this.testOutboundEvent);
        Assert.assertEquals((long)testTimeout, (long)this.dispacher.sensedSendEvent.getTimeout());
    }

    @Test
    public void testObjectAwareInjection() throws Exception {
        EndpointURIEndpointBuilder endpointBuilder = new EndpointURIEndpointBuilder("test://myTestUri", muleContext);
        endpointBuilder.addMessageProcessor((MessageProcessor)new AbstractMessageProcessorTestCase.ObjectAwareProcessor());
        OutboundEndpoint endpoint = endpointBuilder.buildOutboundEndpoint();
        endpoint.process(this.createTestOutboundEvent());
        AbstractMessageProcessorTestCase.ObjectAwareProcessor objectAware = (AbstractMessageProcessorTestCase.ObjectAwareProcessor)endpoint.getMessageProcessors().get(0);
        Assert.assertEquals((Object)muleContext, (Object)objectAware.context);
        Assert.assertEquals((Object)endpoint, (Object)objectAware.endpoint);
    }

    @Test
    public void testTransaction() {
    }

    @Test
    public void testExceptionHandling() {
    }

    protected MuleEvent assertMessageSent(boolean sync) throws MuleException {
        MuleEvent event;
        if (sync) {
            Assert.assertNull((Object)this.dispacher.sensedDispatchEvent);
            Assert.assertNotNull((Object)this.dispacher.sensedSendEvent);
            event = this.dispacher.sensedSendEvent;
        } else {
            Assert.assertNull((Object)this.dispacher.sensedSendEvent);
            Assert.assertNotNull((Object)this.dispacher.sensedDispatchEvent);
            event = this.dispacher.sensedDispatchEvent;
        }
        Assert.assertNotNull((Object)event.getMessage());
        return event;
    }

    protected MuleEvent assertMessageSentSame(boolean sync) throws MuleException {
        MuleEvent event = this.assertMessageSent(sync);
        if (sync) {
            Assert.assertEquals((Object)this.testOutboundEvent, (Object)event);
        }
        Assert.assertEquals((Object)"Test Message", (Object)event.getMessageAsString());
        Assert.assertEquals((Object)"value1", (Object)event.getMessage().getOutboundProperty("prop1"));
        return event;
    }

    protected void assertMessageNotSent() throws MuleException {
        Assert.assertNull((Object)this.dispacher.sensedSendEvent);
        Assert.assertNull((Object)this.dispacher.sensedDispatchEvent);
    }

    protected void assertMessageEqualEncodingPropertyAdded(MuleMessage expect, MuleMessage actual) {
        Assert.assertEquals((Object)expect.getPayload(), (Object)actual.getPayload());
        Assert.assertEquals((Object)expect.getEncoding(), (Object)actual.getEncoding());
        Assert.assertEquals((Object)expect.getUniqueId(), (Object)actual.getUniqueId());
        Assert.assertEquals((Object)expect.getExceptionPayload(), (Object)actual.getExceptionPayload());
        Assert.assertEquals((Object)muleContext.getConfiguration().getDefaultEncoding(), (Object)actual.getOutboundProperty("MULE_ENCODING"));
    }

    protected OutboundEndpoint createOutboundEndpoint(String uri, Filter filter, SecurityFilter securityFilter, Transformer in, Transformer response, MessageExchangePattern exchangePattern, TransactionConfig txConfig) throws Exception {
        OutboundEndpoint endpoint = this.createTestOutboundEndpoint(uri, filter, securityFilter, in, response, exchangePattern, txConfig);
        this.dispacher = new FakeMessageDispatcher(endpoint);
        Connector connector = endpoint.getConnector();
        connector.setDispatcherFactory((MessageDispatcherFactory)new TestMessageDispatcherFactory(){

            @Override
            public MessageDispatcher create(OutboundEndpoint ep) throws MuleException {
                return OutboundEndpointTestCase.this.dispacher;
            }
        });
        return endpoint;
    }

    protected OutboundEndpoint createOutboundEndpoint(Filter filter, SecurityFilter securityFilter, Transformer in, Transformer response, MessageExchangePattern exchangePattern, TransactionConfig txConfig) throws Exception {
        return this.createOutboundEndpoint("test://test", filter, securityFilter, in, response, exchangePattern, txConfig);
    }

    static class FakeMessageDispatcher
    extends TestMessageDispatcher {
        Latch latch = new Latch();
        MuleEvent sensedSendEvent;
        MuleEvent sensedDispatchEvent;

        public FakeMessageDispatcher(OutboundEndpoint endpoint) {
            super(endpoint);
        }

        @Override
        protected MuleMessage doSend(MuleEvent event) throws Exception {
            this.sensedSendEvent = event;
            this.latch.countDown();
            return responseMessage;
        }

        @Override
        protected void doDispatch(MuleEvent event) throws Exception {
            this.sensedDispatchEvent = event;
            this.latch.countDown();
        }
    }
}

