/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.expression.ExpressionRuntimeException;
import org.mule.expression.MessageAttachmentExpressionEvaluator;
import org.mule.expression.MessageAttachmentsExpressionEvaluator;
import org.mule.expression.MessageAttachmentsListExpressionEvaluator;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.util.StringDataSource;

public class AttachmentsExpressionEvaluatorTestCase
extends AbstractMuleContextTestCase {
    private MuleMessage message;

    @Override
    protected void doSetUp() throws Exception {
        try {
            HashMap<String, DataHandler> attachments = new HashMap<String, DataHandler>();
            attachments.put("foo", new DataHandler((DataSource)new StringDataSource("foovalue")));
            attachments.put("bar", new DataHandler((DataSource)new StringDataSource("barvalue")));
            attachments.put("baz", new DataHandler((DataSource)new StringDataSource("bazvalue")));
            this.message = new DefaultMuleMessage((Object)"test", null, attachments, muleContext);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSingleAttachment() throws Exception {
        MessageAttachmentExpressionEvaluator eval = new MessageAttachmentExpressionEvaluator();
        Object result = eval.evaluate("foo", this.message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof DataHandler));
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4);
        ((DataHandler)result).writeTo((OutputStream)baos);
        Assert.assertEquals((Object)"foovalue", (Object)baos.toString());
        result = eval.evaluate("foo?", this.message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof DataHandler));
        baos = new ByteArrayOutputStream(4);
        ((DataHandler)result).writeTo((OutputStream)baos);
        Assert.assertEquals((Object)"foovalue", (Object)baos.toString());
        result = eval.evaluate("fool?", this.message);
        Assert.assertNull((Object)result);
        try {
            eval.evaluate("fool", this.message);
            Assert.fail((String)"required value");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Test
    public void testMapAttachments() throws Exception {
        MessageAttachmentsExpressionEvaluator eval = new MessageAttachmentsExpressionEvaluator();
        Object result = eval.evaluate("foo, baz", this.message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Map));
        Assert.assertEquals((long)2L, (long)((Map)result).size());
        Assert.assertNotNull(((Map)result).get("foo"));
        Assert.assertTrue((boolean)(((Map)result).get("foo") instanceof DataHandler));
        DataHandler dh = (DataHandler)((Map)result).get("foo");
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4);
        dh.writeTo((OutputStream)baos);
        Assert.assertEquals((Object)"foovalue", (Object)baos.toString());
        Assert.assertNotNull(((Map)result).get("baz"));
        Assert.assertTrue((boolean)(((Map)result).get("baz") instanceof DataHandler));
        dh = (DataHandler)((Map)result).get("baz");
        baos = new ByteArrayOutputStream(4);
        dh.writeTo((OutputStream)baos);
        Assert.assertEquals((Object)"bazvalue", (Object)baos.toString());
        result = eval.evaluate("fool?", this.message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Map));
        Assert.assertEquals((long)0L, (long)((Map)result).size());
        try {
            eval.evaluate("fool", this.message);
            Assert.fail((String)"required value");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Test
    public void testMapAttachmentsWithWildcards() throws Exception {
        MessageAttachmentsExpressionEvaluator eval = new MessageAttachmentsExpressionEvaluator();
        Object result = eval.evaluate("*", this.message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Map));
        Assert.assertEquals((long)3L, (long)((Map)result).size());
        Assert.assertNotNull(((Map)result).get("foo"));
        Assert.assertNotNull(((Map)result).get("bar"));
        Assert.assertNotNull(((Map)result).get("baz"));
        result = eval.evaluate("ba*", this.message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Map));
        Assert.assertEquals((long)2L, (long)((Map)result).size());
        Assert.assertNotNull(((Map)result).get("bar"));
        Assert.assertNotNull(((Map)result).get("baz"));
        result = eval.evaluate("x*", this.message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Map));
        Assert.assertEquals((long)0L, (long)((Map)result).size());
        result = eval.evaluate("ba*, f*", this.message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Map));
        Assert.assertEquals((long)3L, (long)((Map)result).size());
        Assert.assertNotNull(((Map)result).get("foo"));
        Assert.assertNotNull(((Map)result).get("bar"));
        Assert.assertNotNull(((Map)result).get("baz"));
    }

    @Test
    public void testListAttachments() throws Exception {
        MessageAttachmentsListExpressionEvaluator eval = new MessageAttachmentsListExpressionEvaluator();
        Object result = eval.evaluate("foo, baz", this.message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof List));
        Assert.assertEquals((long)2L, (long)((List)result).size());
        Assert.assertTrue((boolean)(((List)result).get(0) instanceof DataHandler));
        DataHandler dh = (DataHandler)((List)result).get(0);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4);
        dh.writeTo((OutputStream)baos);
        Assert.assertEquals((Object)"foovalue", (Object)baos.toString());
        Assert.assertTrue((boolean)(((List)result).get(1) instanceof DataHandler));
        dh = (DataHandler)((List)result).get(1);
        baos = new ByteArrayOutputStream(4);
        dh.writeTo((OutputStream)baos);
        Assert.assertEquals((Object)"bazvalue", (Object)baos.toString());
        result = eval.evaluate("*", this.message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof List));
        Assert.assertEquals((long)3L, (long)((List)result).size());
        result = eval.evaluate("fool?", this.message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof List));
        Assert.assertEquals((long)0L, (long)((List)result).size());
        try {
            eval.evaluate("fool", this.message);
            Assert.fail((String)"required value");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Test
    public void testListAttachmentsWithWildcards() throws Exception {
        MessageAttachmentsListExpressionEvaluator eval = new MessageAttachmentsListExpressionEvaluator();
        Object result = eval.evaluate("*", this.message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof List));
        Assert.assertEquals((long)3L, (long)((List)result).size());
        result = eval.evaluate("ba*", this.message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof List));
        Assert.assertEquals((long)2L, (long)((List)result).size());
        result = eval.evaluate("x*", this.message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof List));
        Assert.assertEquals((long)0L, (long)((List)result).size());
        result = eval.evaluate("ba*, f*", this.message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof List));
        Assert.assertEquals((long)3L, (long)((List)result).size());
    }

    @Test
    public void testSingleAttachmentUsingManager() throws Exception {
        Object result = muleContext.getExpressionManager().evaluate("#[attachment:foo]", this.message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof DataHandler));
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4);
        ((DataHandler)result).writeTo((OutputStream)baos);
        Assert.assertEquals((Object)"foovalue", (Object)baos.toString());
        result = muleContext.getExpressionManager().evaluate("#[attachment:fool?]", this.message);
        Assert.assertNull((Object)result);
        try {
            muleContext.getExpressionManager().evaluate("#[attachment:fool]", this.message);
            Assert.fail((String)"Required value");
        }
        catch (ExpressionRuntimeException expressionRuntimeException) {
            // empty catch block
        }
    }

    @Test
    public void testMapAttachmentsUsingManager() throws Exception {
        Object result = muleContext.getExpressionManager().evaluate("#[attachments:foo, baz]", this.message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Map));
        Assert.assertEquals((long)2L, (long)((Map)result).size());
        Assert.assertNotNull(((Map)result).get("foo"));
        Assert.assertTrue((boolean)(((Map)result).get("foo") instanceof DataHandler));
        DataHandler dh = (DataHandler)((Map)result).get("foo");
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4);
        dh.writeTo((OutputStream)baos);
        Assert.assertEquals((Object)"foovalue", (Object)baos.toString());
        Assert.assertNotNull(((Map)result).get("baz"));
        Assert.assertTrue((boolean)(((Map)result).get("baz") instanceof DataHandler));
        dh = (DataHandler)((Map)result).get("baz");
        baos = new ByteArrayOutputStream(4);
        dh.writeTo((OutputStream)baos);
        Assert.assertEquals((Object)"bazvalue", (Object)baos.toString());
        result = muleContext.getExpressionManager().evaluate("#[attachments:fool?]", this.message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Map));
        Assert.assertEquals((long)0L, (long)((Map)result).size());
        try {
            muleContext.getExpressionManager().evaluate("#[attachments:fool]", this.message);
            Assert.fail((String)"Required value");
        }
        catch (ExpressionRuntimeException e) {
            // empty catch block
        }
    }

    @Test
    public void testMapAttachmentsWithWildcardsUsingManager() throws Exception {
        Object result = muleContext.getExpressionManager().evaluate("#[attachments:*]", this.message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Map));
        Assert.assertEquals((long)3L, (long)((Map)result).size());
        Assert.assertNotNull(((Map)result).get("foo"));
        Assert.assertNotNull(((Map)result).get("bar"));
        Assert.assertNotNull(((Map)result).get("baz"));
        result = muleContext.getExpressionManager().evaluate("#[attachments:ba*]", this.message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Map));
        Assert.assertEquals((long)2L, (long)((Map)result).size());
        Assert.assertNotNull(((Map)result).get("bar"));
        Assert.assertNotNull(((Map)result).get("baz"));
        result = muleContext.getExpressionManager().evaluate("#[attachments:x*]", this.message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Map));
        Assert.assertEquals((long)0L, (long)((Map)result).size());
        result = muleContext.getExpressionManager().evaluate("#[attachments:ba*, f*]", this.message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Map));
        Assert.assertEquals((long)3L, (long)((Map)result).size());
        Assert.assertNotNull(((Map)result).get("foo"));
        Assert.assertNotNull(((Map)result).get("bar"));
        Assert.assertNotNull(((Map)result).get("baz"));
    }

    @Test
    public void testListAttachmentsUsingManager() throws Exception {
        Object result = muleContext.getExpressionManager().evaluate("#[attachments-list:foo,baz]", this.message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof List));
        Assert.assertEquals((long)2L, (long)((List)result).size());
        Assert.assertTrue((boolean)(((List)result).get(0) instanceof DataHandler));
        DataHandler dh = (DataHandler)((List)result).get(0);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4);
        dh.writeTo((OutputStream)baos);
        Assert.assertEquals((Object)"foovalue", (Object)baos.toString());
        Assert.assertTrue((boolean)(((List)result).get(1) instanceof DataHandler));
        dh = (DataHandler)((List)result).get(1);
        baos = new ByteArrayOutputStream(4);
        dh.writeTo((OutputStream)baos);
        Assert.assertEquals((Object)"bazvalue", (Object)baos.toString());
        result = muleContext.getExpressionManager().evaluate("#[attachments-list:fool?]", this.message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof List));
        Assert.assertEquals((long)0L, (long)((List)result).size());
        try {
            muleContext.getExpressionManager().evaluate("#[attachments-list:fool]", this.message);
            Assert.fail((String)"Required value");
        }
        catch (ExpressionRuntimeException e) {
            // empty catch block
        }
    }

    @Test
    public void testListAttachmentsWithWildcardsUsingManager() throws Exception {
        Object result = muleContext.getExpressionManager().evaluate("#[attachments-list:*]", this.message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof List));
        Assert.assertEquals((long)3L, (long)((List)result).size());
        result = muleContext.getExpressionManager().evaluate("#[attachments-list:ba*]", this.message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof List));
        Assert.assertEquals((long)2L, (long)((List)result).size());
        result = muleContext.getExpressionManager().evaluate("#[attachments-list:x*]", this.message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof List));
        Assert.assertEquals((long)0L, (long)((List)result).size());
        result = muleContext.getExpressionManager().evaluate("#[attachments-list:ba*, f*]", this.message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof List));
        Assert.assertEquals((long)3L, (long)((List)result).size());
    }
}

