/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.expression.RequiredValueException;
import org.mule.expression.MapPayloadExpressionEvaluator;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class MapPayloadExpressionEvaluatorTestCase
extends AbstractMuleTestCase {
    private Map<String, String> props = new HashMap<String, String>(3);
    private MuleContext muleContext = (MuleContext)Mockito.mock(MuleContext.class);

    @Before
    public void setUpProperties() {
        this.props.clear();
        this.props.put("foo", "moo");
        this.props.put("bar", "mar");
        this.props.put("ba?z", "maz");
    }

    @Test
    public void testExpressions() throws Exception {
        MapPayloadExpressionEvaluator eval = new MapPayloadExpressionEvaluator();
        DefaultMuleMessage message = new DefaultMuleMessage(this.props, (Map)null, this.muleContext);
        Object result = eval.evaluate("foo", (MuleMessage)message);
        Assert.assertEquals((Object)"moo", (Object)result);
        result = eval.evaluate("bar?", (MuleMessage)message);
        Assert.assertEquals((Object)"mar", (Object)result);
        result = eval.evaluate("ba?z", (MuleMessage)message);
        Assert.assertEquals((Object)"maz", (Object)result);
        result = eval.evaluate("fool?", (MuleMessage)message);
        Assert.assertNull((Object)result);
        try {
            eval.evaluate("fool", (MuleMessage)message);
            Assert.fail((String)"Should've failed with an exception.");
        }
        catch (RequiredValueException rex) {
            Assert.assertTrue((boolean)rex.getMessage().contains("fool"));
        }
    }

    @Test
    public void testMultipleExpressions() throws Exception {
        MapPayloadExpressionEvaluator eval = new MapPayloadExpressionEvaluator();
        DefaultMuleMessage message = new DefaultMuleMessage(this.props, (Map)null, this.muleContext);
        Object result = eval.evaluate("foo,bar?,ba?z,fool?", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Map));
        Assert.assertEquals((long)3L, (long)((Map)result).size());
        Assert.assertEquals((Object)"moo", ((Map)result).get("foo"));
        Assert.assertEquals((Object)"mar", ((Map)result).get("bar"));
        Assert.assertEquals((Object)"maz", ((Map)result).get("ba?z"));
        Assert.assertNull(((Map)result).get("fool?"));
    }
}

