/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor.chain;

import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Lifecycle;
import org.mule.api.processor.InterceptingMessageProcessor;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorBuilder;
import org.mule.api.processor.MessageProcessorChain;
import org.mule.processor.AbstractInterceptingMessageProcessor;
import org.mule.processor.chain.DefaultMessageProcessorChain;
import org.mule.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.transformer.simple.StringAppendTransformer;
import org.mule.util.ObjectUtils;

public class DefaultMessageProcessorChainTestCase
extends AbstractMuleContextTestCase {
    @Test
    public void testMPChain() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new AppendingMP("1"), new AppendingMP("2"), new AppendingMP("3")});
        Assert.assertEquals((Object)"0123", (Object)builder.build().process(DefaultMessageProcessorChainTestCase.getTestEventUsingFlow("0")).getMessageAsString());
    }

    @Test
    public void testMPChainWithNullReturn() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        AppendingMP mp1 = new AppendingMP("1");
        AppendingMP mp2 = new AppendingMP("2");
        ReturnNullMP nullmp = new ReturnNullMP();
        AppendingMP mp3 = new AppendingMP("3");
        builder.chain(new MessageProcessor[]{mp1, mp2, nullmp, mp3});
        Assert.assertEquals((Object)"0123", (Object)builder.build().process(DefaultMessageProcessorChainTestCase.getTestEventUsingFlow("0")).getMessageAsString());
        Assert.assertNotSame((Object)mp1.event, (Object)mp1.resultEvent);
        Assert.assertEquals((Object)mp1.resultEvent, (Object)mp2.event);
        Assert.assertNotSame((Object)mp2.event, (Object)mp2.resultEvent);
        Assert.assertEquals((Object)mp2.resultEvent, (Object)nullmp.event);
        Assert.assertNotSame((Object)mp3.event, (Object)mp3.resultEvent);
        Assert.assertNotSame((Object)nullmp.event, (Object)mp3.event);
        Assert.assertEquals((Object)mp3.event.getMessageAsString(), (Object)"012");
    }

    @Test
    public void testMPChainWithNullReturnAtEnd() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new AppendingMP("1"), new AppendingMP("2"), new AppendingMP("3"), new ReturnNullMP()});
        Assert.assertNull((Object)builder.build().process(DefaultMessageProcessorChainTestCase.getTestEventUsingFlow("0")));
    }

    @Test
    public void testMPChainWithBuilder() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new AppendingMP("1")});
        builder.chain(new MessageProcessorBuilder[]{new MessageProcessorBuilder(){

            public MessageProcessor build() {
                return new AppendingMP("2");
            }
        }});
        builder.chain(new MessageProcessor[]{new AppendingMP("3")});
        Assert.assertEquals((Object)"0123", (Object)builder.build().process(DefaultMessageProcessorChainTestCase.getTestEventUsingFlow("0")).getMessageAsString());
    }

    @Test
    public void testInterceptingMPChain() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new AppendingInterceptingMP("1"), new AppendingInterceptingMP("2"), new AppendingInterceptingMP("3")});
        Assert.assertEquals((Object)"0before1before2before3after3after2after1", (Object)builder.build().process(DefaultMessageProcessorChainTestCase.getTestEventUsingFlow("0")).getMessageAsString());
    }

    @Test
    public void testInterceptingMPChainWithNullReturn() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        AppendingInterceptingMP lastMP = new AppendingInterceptingMP("3");
        builder.chain(new MessageProcessor[]{new AppendingInterceptingMP("1"), new AppendingInterceptingMP("2"), new ReturnNullInterceptongMP(), lastMP});
        Assert.assertNull((Object)builder.build().process(DefaultMessageProcessorChainTestCase.getTestEventUsingFlow("0")));
        Assert.assertFalse((boolean)lastMP.invoked);
    }

    @Test
    public void testMixedMPChain() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new AppendingInterceptingMP("1"), new AppendingMP("2"), new AppendingMP("3"), new AppendingInterceptingMP("4"), new AppendingMP("5")});
        Assert.assertEquals((Object)"0before123before45after4after1", (Object)builder.build().process(DefaultMessageProcessorChainTestCase.getTestEventUsingFlow("0")).getMessageAsString());
    }

    @Test
    public void testMixedMPChainWithNullReturn1() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new AppendingInterceptingMP("1"), new ReturnNullInterceptongMP(), new AppendingMP("2"), new AppendingMP("3"), new AppendingInterceptingMP("4"), new AppendingMP("5")});
        Assert.assertNull((Object)builder.build().process(DefaultMessageProcessorChainTestCase.getTestEventUsingFlow("0")));
    }

    @Test
    public void testMixedMPChainWithNullReturn2() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new AppendingInterceptingMP("1"), new AppendingMP("2"), new ReturnNullInterceptongMP(), new AppendingMP("3"), new AppendingInterceptingMP("4"), new AppendingMP("5")});
        Assert.assertNull((Object)builder.build().process(DefaultMessageProcessorChainTestCase.getTestEventUsingFlow("0")));
    }

    @Test
    public void testMixedMPChainWithNullReturn3() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new AppendingInterceptingMP("1"), new ReturnNullMP(), new AppendingMP("2"), new AppendingMP("3"), new AppendingInterceptingMP("4"), new AppendingMP("5")});
        Assert.assertEquals((Object)"0before123before45after4after1", (Object)builder.build().process(DefaultMessageProcessorChainTestCase.getTestEventUsingFlow("0")).getMessageAsString());
    }

    @Test
    public void testMixedMPChainWithNullReturn4() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new AppendingInterceptingMP("1"), new AppendingMP("2"), new ReturnNullMP(), new AppendingMP("3"), new AppendingInterceptingMP("4"), new AppendingMP("5")});
        Assert.assertEquals((Object)"0before123before45after4after1", (Object)builder.build().process(DefaultMessageProcessorChainTestCase.getTestEventUsingFlow("0")).getMessageAsString());
    }

    @Test
    public void testMixedMPChainWithNullReturn5() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new AppendingInterceptingMP("1"), new AppendingMP("2"), new AppendingMP("3"), new ReturnNullMP(), new AppendingInterceptingMP("4"), new AppendingMP("5")});
        Assert.assertEquals((Object)"0before123before45after4after1", (Object)builder.build().process(DefaultMessageProcessorChainTestCase.getTestEventUsingFlow("0")).getMessageAsString());
    }

    @Test
    public void testMixedMPChainWithNullReturnAtEnd() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new AppendingInterceptingMP("1"), new AppendingMP("2"), new AppendingMP("3"), new AppendingInterceptingMP("4"), new AppendingMP("5"), new ReturnNullMP()});
        Assert.assertNull((Object)builder.build().process(DefaultMessageProcessorChainTestCase.getTestEventUsingFlow("0")));
    }

    @Test
    public void testNestedMPChain() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new AppendingMP("1"), new DefaultMessageProcessorChainBuilder().chain(new MessageProcessor[]{new AppendingMP("a"), new AppendingMP("b")}).build(), new AppendingMP("2")});
        Assert.assertEquals((Object)"01ab2", (Object)builder.build().process(DefaultMessageProcessorChainTestCase.getTestEventUsingFlow("0")).getMessageAsString());
    }

    @Test
    public void testNestedMPChainWithNullReturn() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new AppendingMP("1"), new DefaultMessageProcessorChainBuilder().chain(new MessageProcessor[]{new AppendingMP("a"), new ReturnNullMP(), new AppendingMP("b")}).build(), new ReturnNullMP(), new AppendingMP("2")});
        Assert.assertEquals((Object)"01ab2", (Object)builder.build().process(DefaultMessageProcessorChainTestCase.getTestEventUsingFlow("0")).getMessageAsString());
    }

    @Test
    public void testNestedMPChainWithNullReturnAtEndOfNestedChain() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new AppendingMP("1"), new DefaultMessageProcessorChainBuilder().chain(new MessageProcessor[]{new AppendingMP("a"), new AppendingMP("b"), new ReturnNullMP()}).build(), new AppendingMP("2")});
        Assert.assertNull((Object)builder.build().process(DefaultMessageProcessorChainTestCase.getTestEventUsingFlow("0")));
    }

    @Test
    public void testNestedMPChainWithNullReturnAtEndOfNestedChainWithNonInterceptingWrapper() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        MessageProcessorChain nested = new DefaultMessageProcessorChainBuilder().chain(new MessageProcessor[]{new AppendingMP("a"), new AppendingMP("b"), new ReturnNullMP()}).build();
        builder.chain(new MessageProcessor[]{new AppendingMP("1"), new MessageProcessor((MessageProcessor)nested){
            final /* synthetic */ MessageProcessor val$nested;
            {
                this.val$nested = messageProcessor;
            }

            public MuleEvent process(MuleEvent event) throws MuleException {
                return this.val$nested.process(event);
            }
        }, new AppendingMP("2")});
        Assert.assertEquals((Object)"012", (Object)builder.build().process(DefaultMessageProcessorChainTestCase.getTestEventUsingFlow("0")).getMessageAsString());
    }

    @Test
    public void testNestedInterceptingMPChain() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new AppendingInterceptingMP("1"), new DefaultMessageProcessorChainBuilder().chain(new MessageProcessor[]{new AppendingInterceptingMP("a"), new AppendingInterceptingMP("b")}).build(), new AppendingInterceptingMP("2")});
        Assert.assertEquals((Object)"0before1beforeabeforebafterbafterabefore2after2after1", (Object)builder.build().process(DefaultMessageProcessorChainTestCase.getTestEventUsingFlow("0")).getMessageAsString());
    }

    @Test
    public void testNestedInterceptingMPChainWithNullReturn() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new AppendingInterceptingMP("1"), new DefaultMessageProcessorChainBuilder().chain(new MessageProcessor[]{new AppendingInterceptingMP("a"), new ReturnNullInterceptongMP(), new AppendingInterceptingMP("b")}).build(), new AppendingInterceptingMP("2")});
        Assert.assertNull((Object)builder.build().process(DefaultMessageProcessorChainTestCase.getTestEventUsingFlow("0")));
    }

    @Test
    public void testNestedMixedMPChain() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new AppendingMP("1"), new DefaultMessageProcessorChainBuilder().chain(new MessageProcessor[]{new AppendingInterceptingMP("a"), new AppendingMP("b")}).build(), new AppendingInterceptingMP("2")});
        Assert.assertEquals((Object)"01beforeabafterabefore2after2", (Object)builder.build().process(DefaultMessageProcessorChainTestCase.getTestEventUsingFlow("0")).getMessageAsString());
    }

    @Test
    public void testInterceptingMPChainStopFlow() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new AppendingInterceptingMP("1"), new AppendingInterceptingMP("2", true), new AppendingInterceptingMP("3")});
        Assert.assertEquals((Object)"0before1after1", (Object)builder.build().process(DefaultMessageProcessorChainTestCase.getTestEventUsingFlow("0")).getMessageAsString());
    }

    @Test
    public void testNestedInterceptingMPChainStopFlow() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new AppendingInterceptingMP("1"), new DefaultMessageProcessorChainBuilder().chain(new MessageProcessor[]{new AppendingInterceptingMP("a", true), new AppendingInterceptingMP("b")}).build(), new AppendingInterceptingMP("3")});
        Assert.assertEquals((Object)"0before1before3after3after1", (Object)builder.build().process(DefaultMessageProcessorChainTestCase.getTestEventUsingFlow("0")).getMessageAsString());
    }

    @Test
    public void testMPChainLifecycle() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        AppendingInterceptingMP mp1 = new AppendingInterceptingMP("1");
        AppendingInterceptingMP mp2 = new AppendingInterceptingMP("2");
        MessageProcessorChain chain = builder.chain(new MessageProcessor[]{mp1, mp2}).build();
        ((Lifecycle)chain).initialise();
        ((Lifecycle)chain).start();
        ((Lifecycle)chain).stop();
        ((Lifecycle)chain).dispose();
        this.assertLifecycle(mp1);
        this.assertLifecycle(mp2);
    }

    @Test
    public void testNestedMPChainLifecycle() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        DefaultMessageProcessorChainBuilder nestedBuilder = new DefaultMessageProcessorChainBuilder();
        AppendingInterceptingMP mp1 = new AppendingInterceptingMP("1");
        AppendingInterceptingMP mp2 = new AppendingInterceptingMP("2");
        AppendingInterceptingMP mpa = new AppendingInterceptingMP("a");
        AppendingInterceptingMP mpb = new AppendingInterceptingMP("b");
        MessageProcessorChain chain = builder.chain(new MessageProcessor[]{mp1, nestedBuilder.chain(new MessageProcessor[]{mpa, mpb}).build(), mp2}).build();
        ((Lifecycle)chain).initialise();
        ((Lifecycle)chain).start();
        ((Lifecycle)chain).stop();
        ((Lifecycle)chain).dispose();
        this.assertLifecycle(mp1);
        this.assertLifecycle(mp2);
        this.assertLifecycle(mpa);
        this.assertLifecycle(mpb);
    }

    @Test
    public void testNoneIntercepting() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new TestNonIntercepting(), new TestNonIntercepting(), new TestNonIntercepting()});
        MuleEvent restul = builder.build().process(DefaultMessageProcessorChainTestCase.getTestEventUsingFlow(""));
        Assert.assertEquals((Object)"MessageProcessorMessageProcessorMessageProcessor", (Object)restul.getMessageAsString());
    }

    @Test
    public void testAllIntercepting() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new TestIntercepting(), new TestIntercepting(), new TestIntercepting()});
        MuleEvent restul = builder.build().process(DefaultMessageProcessorChainTestCase.getTestEventUsingFlow(""));
        Assert.assertEquals((Object)"InterceptingMessageProcessorInterceptingMessageProcessorInterceptingMessageProcessor", (Object)restul.getMessageAsString());
    }

    @Test
    public void testMix() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new TestIntercepting(), new TestNonIntercepting(), new TestNonIntercepting(), new TestIntercepting(), new TestNonIntercepting(), new TestNonIntercepting()});
        MuleEvent restul = builder.build().process(DefaultMessageProcessorChainTestCase.getTestEventUsingFlow(""));
        Assert.assertEquals((Object)"InterceptingMessageProcessorMessageProcessorMessageProcessorInterceptingMessageProcessorMessageProcessorMessageProcessor", (Object)restul.getMessageAsString());
    }

    @Test
    public void testMixStaticFactoryt() throws Exception {
        MessageProcessorChain chain = DefaultMessageProcessorChain.from((MessageProcessor[])new MessageProcessor[]{new TestIntercepting(), new TestNonIntercepting(), new TestNonIntercepting(), new TestIntercepting(), new TestNonIntercepting(), new TestNonIntercepting()});
        MuleEvent restul = chain.process(DefaultMessageProcessorChainTestCase.getTestEventUsingFlow(""));
        Assert.assertEquals((Object)"InterceptingMessageProcessorMessageProcessorMessageProcessorInterceptingMessageProcessorMessageProcessorMessageProcessor", (Object)restul.getMessageAsString());
    }

    @Test
    public void testMix2() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new TestNonIntercepting(), new TestIntercepting(), new TestNonIntercepting(), new TestNonIntercepting(), new TestNonIntercepting(), new TestIntercepting()});
        MuleEvent restul = builder.build().process(DefaultMessageProcessorChainTestCase.getTestEventUsingFlow(""));
        Assert.assertEquals((Object)"MessageProcessorInterceptingMessageProcessorMessageProcessorMessageProcessorMessageProcessorInterceptingMessageProcessor", (Object)restul.getMessageAsString());
    }

    @Test
    public void testMix2StaticFactory() throws Exception {
        MessageProcessorChain chain = DefaultMessageProcessorChain.from((MessageProcessor[])new MessageProcessor[]{new TestNonIntercepting(), new TestIntercepting(), new TestNonIntercepting(), new TestNonIntercepting(), new TestNonIntercepting(), new TestIntercepting()});
        MuleEvent restul = chain.process(DefaultMessageProcessorChainTestCase.getTestEventUsingFlow(""));
        Assert.assertEquals((Object)"MessageProcessorInterceptingMessageProcessorMessageProcessorMessageProcessorMessageProcessorInterceptingMessageProcessor", (Object)restul.getMessageAsString());
    }

    private void assertLifecycle(AppendingMP mp) {
        Assert.assertTrue((boolean)mp.initialised);
        Assert.assertTrue((boolean)mp.started);
        Assert.assertTrue((boolean)mp.stopped);
        Assert.assertTrue((boolean)mp.disposed);
    }

    private static class ReturnNullInterceptongMP
    extends AbstractInterceptingMessageProcessor {
        private ReturnNullInterceptongMP() {
        }

        public MuleEvent process(MuleEvent event) throws MuleException {
            return null;
        }
    }

    private static class ReturnNullMP
    implements MessageProcessor {
        MuleEvent event;

        private ReturnNullMP() {
        }

        public MuleEvent process(MuleEvent event) throws MuleException {
            this.event = event;
            event.getMessage().setPayload((Object)"RUBBISH");
            return null;
        }
    }

    private static class AppendingInterceptingMP
    extends AppendingMP
    implements InterceptingMessageProcessor {
        private boolean stopProcessing;
        private MessageProcessor next;
        boolean invoked = false;

        public AppendingInterceptingMP(String append) {
            this(append, false);
        }

        public AppendingInterceptingMP(String append, boolean stopProcessing) {
            super(append);
            this.stopProcessing = stopProcessing;
        }

        @Override
        public MuleEvent process(MuleEvent event) throws MuleException {
            this.invoked = true;
            this.event = event;
            if (this.stopProcessing) {
                return event;
            }
            DefaultMuleEvent intermediateEvent = new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)(event.getMessageAsString() + "before" + this.appendString), muleContext), event);
            if (this.next != null) {
                intermediateEvent = this.next.process((MuleEvent)intermediateEvent);
            }
            if (intermediateEvent != null) {
                return new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)(intermediateEvent.getMessageAsString() + "after" + this.appendString), muleContext), (MuleEvent)intermediateEvent);
            }
            return null;
        }

        public void setListener(MessageProcessor mp) {
            this.next = mp;
        }

        @Override
        public String toString() {
            return ObjectUtils.toString((Object)this);
        }
    }

    private static class AppendingMP
    implements MessageProcessor,
    Lifecycle {
        String appendString;
        boolean initialised;
        boolean started;
        boolean stopped;
        boolean disposed;
        MuleEvent event;
        MuleEvent resultEvent;

        public AppendingMP(String append) {
            this.appendString = append;
        }

        public MuleEvent process(MuleEvent event) throws MuleException {
            this.event = event;
            DefaultMuleEvent result = new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)(event.getMessageAsString() + this.appendString), muleContext), event);
            this.resultEvent = result;
            return result;
        }

        public void initialise() throws InitialisationException {
            this.initialised = true;
        }

        public void start() throws MuleException {
            this.started = true;
        }

        public void stop() throws MuleException {
            this.stopped = true;
        }

        public void dispose() {
            this.disposed = true;
        }

        public String toString() {
            return ObjectUtils.toString((Object)this);
        }
    }

    static class TestIntercepting
    extends AbstractInterceptingMessageProcessor {
        TestIntercepting() {
        }

        public MuleEvent process(MuleEvent event) throws MuleException {
            return this.processNext(new StringAppendTransformer("InterceptingMessageProcessor").process(event));
        }
    }

    static class TestNonIntercepting
    implements MessageProcessor {
        TestNonIntercepting() {
        }

        public MuleEvent process(MuleEvent event) throws MuleException {
            return new StringAppendTransformer("MessageProcessor").process(event);
        }
    }
}

