/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.service.Service;
import org.mule.routing.CollectionSplitter;
import org.mule.routing.outbound.IteratorMessageSequence;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class CollectionMessageSplitterTestCase
extends AbstractMuleContextTestCase {
    private static final List<String> TEST_LIST = Arrays.asList("abc", "def", "ghi");

    public CollectionMessageSplitterTestCase() {
        this.setStartContext(true);
    }

    @Test
    public void testRouterCollection() throws Exception {
        this.assertRouted(TEST_LIST, 3, true);
    }

    @Test
    public void testRouterIterable() throws Exception {
        Iterable mock = (Iterable)Mockito.mock(Iterable.class);
        Mockito.when(mock.iterator()).thenReturn(TEST_LIST.iterator());
        this.assertRouted(mock, 3, false);
        ((Iterable)Mockito.verify((Object)mock, (VerificationMode)Mockito.times((int)1))).iterator();
    }

    @Test
    public void testRouterIterator() throws Exception {
        this.assertRouted(TEST_LIST.iterator(), 3, false);
    }

    @Test
    public void testRouterMesseageSequence() throws Exception {
        this.assertRouted(new IteratorMessageSequence(TEST_LIST.iterator()), 3, false);
    }

    @Test
    public void testEmptySequence() throws Exception {
        Set payload = Collections.emptySet();
        Service fc = CollectionMessageSplitterTestCase.getTestService();
        MuleSession session = CollectionMessageSplitterTestCase.getTestSession(fc, muleContext);
        DefaultMuleMessage toSplit = new DefaultMuleMessage(payload, new HashMap(), new HashMap(), null, muleContext);
        CollectionSplitter splitter = new CollectionSplitter();
        splitter.setMuleContext(muleContext);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)toSplit, CollectionMessageSplitterTestCase.getTestInboundEndpoint("ep"), session);
        Assert.assertNull((Object)splitter.process((MuleEvent)event));
    }

    private void assertRouted(Object payload, int count, boolean counted) throws Exception, MuleException {
        Service fc = CollectionMessageSplitterTestCase.getTestService();
        MuleSession session = CollectionMessageSplitterTestCase.getTestSession(fc, muleContext);
        HashMap<String, Object> inboundProps = new HashMap<String, Object>();
        inboundProps.put("inbound1", "1");
        inboundProps.put("inbound2", 2);
        inboundProps.put("inbound3", session);
        HashMap<String, Object> outboundProps = new HashMap<String, Object>();
        outboundProps.put("outbound1", "3");
        outboundProps.put("outbound2", 4);
        outboundProps.put("outbound3", session);
        HashMap<String, Object> invocationProps = new HashMap<String, Object>();
        invocationProps.put("invoke1", "5");
        invocationProps.put("invoke2", 6);
        invocationProps.put("invoke3", session);
        HashSet<Integer> expectedSequences = new HashSet<Integer>();
        for (int i = 1; i <= count; ++i) {
            expectedSequences.add(i);
        }
        DefaultMuleMessage toSplit = new DefaultMuleMessage(payload, inboundProps, outboundProps, null, muleContext);
        for (Map.Entry entry : invocationProps.entrySet()) {
            toSplit.setInvocationProperty((String)entry.getKey(), entry.getValue());
        }
        CollectionSplitter splitter = new CollectionSplitter();
        splitter.setMuleContext(muleContext);
        Grabber grabber = new Grabber();
        splitter.setListener((MessageProcessor)grabber);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)toSplit, CollectionMessageSplitterTestCase.getTestInboundEndpoint("ep"), session);
        splitter.process((MuleEvent)event);
        List<MuleMessage> splits = grabber.getMessages();
        Assert.assertEquals((long)count, (long)splits.size());
        HashSet<Object> actualSequences = new HashSet<Object>();
        for (MuleMessage msg : splits) {
            Assert.assertTrue((boolean)(msg.getPayload() instanceof String));
            Assert.assertEquals((Object)(counted ? count : -1), (Object)msg.getOutboundProperty("MULE_CORRELATION_GROUP_SIZE"));
            actualSequences.add(msg.getOutboundProperty("MULE_CORRELATION_SEQUENCE"));
            String str = (String)msg.getPayload();
            Assert.assertTrue((boolean)TEST_LIST.contains(str));
            for (String key : inboundProps.keySet()) {
                Assert.assertEquals((Object)msg.getInboundProperty(key), inboundProps.get(key));
            }
            for (String key : outboundProps.keySet()) {
                Assert.assertEquals((Object)msg.getOutboundProperty(key), outboundProps.get(key));
            }
            for (String key : invocationProps.keySet()) {
                Assert.assertEquals((Object)msg.getInvocationProperty(key), invocationProps.get(key));
            }
        }
        Assert.assertEquals(expectedSequences, actualSequences);
    }

    private static class Grabber
    implements MessageProcessor {
        private List<MuleMessage> messages = new ArrayList<MuleMessage>();

        private Grabber() {
        }

        public MuleEvent process(MuleEvent event) throws MuleException {
            this.messages.add(event.getMessage());
            return null;
        }

        public List<MuleMessage> getMessages() {
            return this.messages;
        }
    }
}

