/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.util.Comparator;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.service.Service;
import org.mule.routing.EventGroup;
import org.mule.routing.Resequencer;
import org.mule.routing.correlation.CorrelationSequenceComparator;
import org.mule.routing.correlation.EventCorrelatorCallback;
import org.mule.routing.correlation.ResequenceMessagesCorrelatorCallback;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.fruit.Apple;

public class ResequencerTestCase
extends AbstractMuleContextTestCase {
    public ResequencerTestCase() {
        this.setStartContext(true);
    }

    @Test
    public void testMessageResequencer() throws Exception {
        MuleSession session = ResequencerTestCase.getTestSession(ResequencerTestCase.getTestService(), muleContext);
        Service testService = ResequencerTestCase.getTestService("test", Apple.class);
        Assert.assertNotNull((Object)testService);
        TestEventResequencer router = new TestEventResequencer(3);
        router.setMuleContext(muleContext);
        router.setFlowConstruct((FlowConstruct)testService);
        router.initialise();
        DefaultMuleMessage message1 = new DefaultMuleMessage((Object)"test event A", muleContext);
        DefaultMuleMessage message2 = new DefaultMuleMessage((Object)"test event B", muleContext);
        DefaultMuleMessage message3 = new DefaultMuleMessage((Object)"test event C", muleContext);
        String correlationId = message1.getUniqueId();
        message1.setCorrelationId(correlationId);
        message2.setCorrelationId(correlationId);
        message3.setCorrelationId(correlationId);
        InboundEndpoint endpoint = MuleTestUtils.getTestInboundEndpoint(MessageExchangePattern.ONE_WAY, muleContext);
        DefaultMuleEvent event1 = new DefaultMuleEvent((MuleMessage)message1, endpoint, session);
        DefaultMuleEvent event2 = new DefaultMuleEvent((MuleMessage)message2, endpoint, session);
        DefaultMuleEvent event3 = new DefaultMuleEvent((MuleMessage)message3, endpoint, session);
        Assert.assertNull((Object)router.process((MuleEvent)event2));
        Assert.assertNull((Object)router.process((MuleEvent)event3));
        MuleEvent resultEvent = router.process((MuleEvent)event1);
        Assert.assertNotNull((Object)resultEvent);
        MuleMessage resultMessage = resultEvent.getMessage();
        Assert.assertNotNull((Object)resultMessage);
        Assert.assertTrue((resultMessage.getPayloadAsString().equals("test event A") || resultMessage.getPayloadAsString().equals("test event B") || resultMessage.getPayloadAsString().equals("test event C") ? 1 : 0) != 0);
        router = new TestEventResequencer(3);
        router.setMuleContext(muleContext);
        router.setEventComparator(new EventPayloadComparator());
        testService.setName("testService2");
        router.setFlowConstruct((FlowConstruct)testService);
        router.initialise();
        Assert.assertNull((Object)router.process((MuleEvent)event2));
        Assert.assertNull((Object)router.process((MuleEvent)event3));
        resultEvent = router.process((MuleEvent)event1);
        Assert.assertNotNull((Object)resultEvent);
        resultMessage = resultEvent.getMessage();
        Assert.assertNotNull((Object)resultMessage);
        Assert.assertEquals((Object)"test event C", (Object)resultMessage.getPayloadAsString());
    }

    public static class EventPayloadComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            try {
                return ((MuleEvent)o1).getMessageAsString().compareTo(((MuleEvent)o2).getMessageAsString());
            }
            catch (MuleException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    public static class TestEventResequencer
    extends Resequencer {
        private int eventCount = 0;
        private int eventthreshold = 1;

        public TestEventResequencer(int eventthreshold) {
            this.eventthreshold = eventthreshold;
            this.setEventComparator((Comparator)new CorrelationSequenceComparator());
        }

        protected EventCorrelatorCallback getCorrelatorCallback(MuleContext muleContext) {
            return new ResequenceMessagesCorrelatorCallback(this.getEventComparator(), muleContext, false, this.storePrefix){

                public boolean shouldAggregateEvents(EventGroup events) {
                    TestEventResequencer.this.eventCount++;
                    if (TestEventResequencer.this.eventCount == TestEventResequencer.this.eventthreshold) {
                        TestEventResequencer.this.eventCount = 0;
                        return true;
                    }
                    return false;
                }
            };
        }
    }
}

