/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.service.Service;
import org.mule.routing.SimpleCollectionAggregator;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.fruit.Apple;

public class SimpleCollectionAggregatorTestCase
extends AbstractMuleContextTestCase {
    public SimpleCollectionAggregatorTestCase() {
        this.setStartContext(true);
    }

    @Test
    public void testMessageProcessor() throws Exception {
        MuleSession session = SimpleCollectionAggregatorTestCase.getTestSession(SimpleCollectionAggregatorTestCase.getTestService(), muleContext);
        Service testService = SimpleCollectionAggregatorTestCase.getTestService("test", Apple.class);
        Assert.assertNotNull((Object)testService);
        SimpleCollectionAggregator router = new SimpleCollectionAggregator();
        router.setMuleContext(muleContext);
        router.setFlowConstruct((FlowConstruct)testService);
        router.initialise();
        DefaultMuleMessage message1 = new DefaultMuleMessage((Object)"test event A", muleContext);
        DefaultMuleMessage message2 = new DefaultMuleMessage((Object)"test event B", muleContext);
        DefaultMuleMessage message3 = new DefaultMuleMessage((Object)"test event C", muleContext);
        message1.setCorrelationId(message1.getUniqueId());
        message2.setCorrelationId(message1.getUniqueId());
        message3.setCorrelationId(message1.getUniqueId());
        message1.setCorrelationGroupSize(3);
        InboundEndpoint endpoint = MuleTestUtils.getTestInboundEndpoint(MessageExchangePattern.ONE_WAY, muleContext);
        DefaultMuleEvent event1 = new DefaultMuleEvent((MuleMessage)message1, endpoint, session);
        DefaultMuleEvent event2 = new DefaultMuleEvent((MuleMessage)message2, endpoint, session);
        DefaultMuleEvent event3 = new DefaultMuleEvent((MuleMessage)message3, endpoint, session);
        Assert.assertNull((Object)router.process((MuleEvent)event1));
        Assert.assertNull((Object)router.process((MuleEvent)event2));
        MuleEvent resultEvent = router.process((MuleEvent)event3);
        Assert.assertNotNull((Object)resultEvent);
        MuleMessage resultMessage = resultEvent.getMessage();
        Assert.assertNotNull((Object)resultMessage);
        List payload = (List)resultMessage.getPayload();
        Assert.assertEquals((long)3L, (long)payload.size());
        Object[] results = new String[3];
        results = payload.toArray(results);
        Arrays.sort(results);
        Assert.assertEquals((Object)"test event A", (Object)results[0]);
        Assert.assertEquals((Object)"test event B", (Object)results[1]);
        Assert.assertEquals((Object)"test event C", (Object)results[2]);
    }
}

