/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transaction;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.api.transaction.Transaction;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.transaction.IllegalTransactionStateException;
import org.mule.transaction.TransactionCoordination;

public class TransactionCoordinationTestCase
extends AbstractMuleTestCase {
    private TransactionCoordination tc;

    @Before
    public void setUpTransaction() throws Exception {
        this.tc = TransactionCoordination.getInstance();
    }

    @After
    public void unbindTransaction() throws Exception {
        this.tc.unbindTransaction(this.tc.getTransaction());
    }

    @Test
    public void testBindTransaction() throws Exception {
        Assert.assertNull((Object)this.tc.getTransaction());
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        this.tc.bindTransaction(tx);
        Assert.assertEquals((Object)tx, (Object)this.tc.getTransaction());
        this.tc.unbindTransaction(tx);
    }

    @Test
    public void testBindTransactionWithAlreadyBound() throws Exception {
        Assert.assertNull((Object)this.tc.getTransaction());
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        this.tc.bindTransaction(tx);
        Assert.assertEquals((Object)tx, (Object)this.tc.getTransaction());
        try {
            Transaction tx2 = (Transaction)Mockito.mock(Transaction.class);
            this.tc.bindTransaction(tx2);
            Assert.fail();
        }
        catch (IllegalTransactionStateException illegalTransactionStateException) {
            // empty catch block
        }
        this.tc.unbindTransaction(tx);
    }

    @Test
    public void testUnbindTransactionWithoutBound() throws Exception {
        Assert.assertNull((Object)this.tc.getTransaction());
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        this.tc.unbindTransaction(tx);
    }

    @Test
    public void testSetInstanceWithBound() throws Exception {
        Assert.assertNull((Object)this.tc.getTransaction());
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        this.tc.bindTransaction(tx);
        this.tc.unbindTransaction(tx);
    }
}

