/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer;

import org.junit.Assert;
import org.junit.Test;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.AbstractTransformerTestCase;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transport.NullPayload;

public class NullResultTestCase
extends AbstractTransformerTestCase {
    private final NullResultTransformer transformer = new NullResultTransformer();

    @Override
    public Object getTestData() {
        return new Object();
    }

    @Override
    public Object getResultData() {
        return NullPayload.getInstance();
    }

    @Override
    public Transformer getTransformer() throws Exception {
        return this.transformer;
    }

    @Override
    public Transformer getRoundTripTransformer() throws Exception {
        return null;
    }

    @Test
    public void testNullNotExpected() throws Exception {
        this.transformer.setReturnDataType(DataTypeFactory.STRING);
        try {
            this.testTransform();
            Assert.fail((String)"Transformer should have thrown an exception because the return class doesn't match the result.");
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
    }

    public static final class NullResultTransformer
    extends AbstractTransformer {
        public NullResultTransformer() {
            this.registerSourceType(DataTypeFactory.OBJECT);
            this.setReturnDataType(DataTypeFactory.create(NullPayload.class));
        }

        public Object doTransform(Object src, String encoding) throws TransformerException {
            return null;
        }
    }
}

