/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.testmodels.fruit.AbstractFruit;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Banana;
import org.mule.tck.testmodels.fruit.Fruit;
import org.mule.tck.testmodels.fruit.FruitBowl;
import org.mule.tck.testmodels.fruit.Orange;
import org.mule.tck.testmodels.fruit.WaterMelon;
import org.mule.util.ClassUtils;

public class ClassUtilsTestCase
extends AbstractMuleTestCase {
    protected final Set<String> ignoreMethods = new HashSet<String>(Arrays.asList("equals", "getInvocationHandler"));

    @Test
    public void testIsConcrete() throws Exception {
        Assert.assertTrue((boolean)ClassUtils.isConcrete(Orange.class));
        Assert.assertTrue((!ClassUtils.isConcrete(Fruit.class) ? 1 : 0) != 0);
        Assert.assertTrue((!ClassUtils.isConcrete(AbstractFruit.class) ? 1 : 0) != 0);
        try {
            ClassUtils.isConcrete(null);
            Assert.fail((String)"Class cannot be null, exception should be thrown");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testLoadClass() throws Exception {
        Class clazz = ClassUtils.loadClass((String)"java.lang.String", this.getClass());
        Assert.assertNotNull((Object)clazz);
        Assert.assertEquals((Object)clazz.getName(), (Object)"java.lang.String");
        try {
            ClassUtils.loadClass((String)"java.lang.Bing", this.getClass());
            Assert.fail((String)"ClassNotFoundException should be thrown");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testLoadPrimitiveClass() throws Exception {
        Assert.assertSame((Object)ClassUtils.loadClass((String)"boolean", this.getClass()), Boolean.TYPE);
        Assert.assertSame((Object)ClassUtils.loadClass((String)"byte", this.getClass()), Byte.TYPE);
        Assert.assertSame((Object)ClassUtils.loadClass((String)"char", this.getClass()), Character.TYPE);
        Assert.assertSame((Object)ClassUtils.loadClass((String)"double", this.getClass()), Double.TYPE);
        Assert.assertSame((Object)ClassUtils.loadClass((String)"float", this.getClass()), Float.TYPE);
        Assert.assertSame((Object)ClassUtils.loadClass((String)"int", this.getClass()), Integer.TYPE);
        Assert.assertSame((Object)ClassUtils.loadClass((String)"long", this.getClass()), Long.TYPE);
        Assert.assertSame((Object)ClassUtils.loadClass((String)"short", this.getClass()), Short.TYPE);
    }

    @Test
    public void testLoadClassOfType() throws Exception {
        Class clazz = ClassUtils.loadClass((String)"java.lang.IllegalArgumentException", this.getClass(), Exception.class);
        Assert.assertNotNull((Object)clazz);
        Assert.assertEquals((Object)clazz.getName(), (Object)"java.lang.IllegalArgumentException");
        try {
            ClassUtils.loadClass((String)"java.lang.UnsupportedOperationException", this.getClass(), String.class);
            Assert.fail((String)"IllegalArgumentException should be thrown since class is not of expected type");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testInstanciateClass() throws Exception {
        Object object = ClassUtils.instanciateClass((String)"org.mule.tck.testmodels.fruit.Orange", (Object[])new Object[0]);
        Assert.assertNotNull((Object)object);
        Assert.assertTrue((boolean)(object instanceof Orange));
        object = ClassUtils.instanciateClass((String)"org.mule.tck.testmodels.fruit.FruitBowl", (Object[])new Object[]{new Apple(), new Banana()});
        Assert.assertNotNull((Object)object);
        Assert.assertTrue((boolean)(object instanceof FruitBowl));
        FruitBowl bowl = (FruitBowl)object;
        Assert.assertTrue((boolean)bowl.hasApple());
        Assert.assertTrue((boolean)bowl.hasBanana());
        try {
            ClassUtils.instanciateClass((String)"java.lang.Bing", (Object[])new Object[0]);
            Assert.fail((String)"Class does not exist, ClassNotFoundException should have been thrown");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testGetParameterTypes() throws Exception {
        FruitBowl bowl = new FruitBowl();
        Class[] classes = ClassUtils.getParameterTypes((Object)bowl, (String)"apple");
        Assert.assertNotNull((Object)classes);
        Assert.assertEquals((long)1L, (long)classes.length);
        Assert.assertEquals(Apple.class, (Object)classes[0]);
        classes = ClassUtils.getParameterTypes((Object)bowl, (String)"invalid");
        Assert.assertNotNull((Object)classes);
        Assert.assertEquals((long)0L, (long)classes.length);
    }

    @Test
    public void testLoadingResources() throws Exception {
        URL resource = ClassUtils.getResource((String)"log4j.properties", this.getClass());
        Assert.assertNotNull((Object)resource);
        resource = ClassUtils.getResource((String)"does-not-exist.properties", this.getClass());
        Assert.assertNull((Object)resource);
    }

    @Test
    public void testLoadingResourceEnumeration() throws Exception {
        Enumeration enumeration = ClassUtils.getResources((String)"log4j.properties", this.getClass());
        Assert.assertNotNull((Object)enumeration);
        Assert.assertTrue((boolean)enumeration.hasMoreElements());
        enumeration = ClassUtils.getResources((String)"does-not-exist.properties", this.getClass());
        Assert.assertNotNull((Object)enumeration);
        Assert.assertTrue((!enumeration.hasMoreElements() ? 1 : 0) != 0);
    }

    @Test
    public void testGetSatisfiableMethods() throws Exception {
        List methods = ClassUtils.getSatisfiableMethods(FruitBowl.class, (Class[])new Class[]{Apple.class}, (boolean)true, (boolean)true, this.ignoreMethods);
        Assert.assertNotNull((Object)methods);
        Assert.assertEquals((long)2L, (long)methods.size());
        methods = ClassUtils.getSatisfiableMethods(FruitBowl.class, (Class[])new Class[]{Apple.class}, (boolean)false, (boolean)true, this.ignoreMethods);
        Assert.assertNotNull((Object)methods);
        Assert.assertEquals((long)0L, (long)methods.size());
        methods = ClassUtils.getSatisfiableMethods(DummyObject.class, (Class[])new Class[]{WaterMelon.class}, (boolean)true, (boolean)false, this.ignoreMethods);
        Assert.assertNotNull((Object)methods);
        Assert.assertEquals((long)0L, (long)methods.size());
        methods = ClassUtils.getSatisfiableMethods(DummyObject.class, (Class[])new Class[]{WaterMelon.class}, (boolean)true, (boolean)true, this.ignoreMethods);
        Assert.assertNotNull((Object)methods);
        Assert.assertEquals((long)2L, (long)methods.size());
        methods = ClassUtils.getSatisfiableMethods(DummyObject.class, (Class[])new Class[]{WaterMelon.class}, (boolean)false, (boolean)true, this.ignoreMethods);
        Assert.assertNotNull((Object)methods);
        Assert.assertEquals((long)1L, (long)methods.size());
        Assert.assertEquals((Object)"doSomethingElse", (Object)((Method)methods.get(0)).getName());
        methods = ClassUtils.getSatisfiableMethods(FruitBowl.class, (Class[])new Class[]{WaterMelon[].class}, (boolean)true, (boolean)true, this.ignoreMethods);
        Assert.assertNotNull((Object)methods);
        Assert.assertEquals((long)1L, (long)methods.size());
        Assert.assertEquals((Object)"setFruit", (Object)((Method)methods.get(0)).getName());
    }

    @Test
    public void testSimpleName() {
        this.simpleNameHelper("String", "foo".getClass());
        this.simpleNameHelper("int[]", new int[0].getClass());
        this.simpleNameHelper("Object[][]", new Object[0][0].getClass());
        this.simpleNameHelper("null", null);
    }

    @Test
    public void testEqual() {
        HashBlob a1 = new HashBlob(1);
        HashBlob a2 = new HashBlob(1);
        HashBlob b = new HashBlob(2);
        Assert.assertTrue((boolean)ClassUtils.equal((Object)a1, (Object)a2));
        Assert.assertTrue((boolean)ClassUtils.equal((Object)b, (Object)b));
        Assert.assertTrue((boolean)ClassUtils.equal(null, null));
        Assert.assertFalse((boolean)ClassUtils.equal((Object)a1, (Object)b));
        Assert.assertFalse((boolean)ClassUtils.equal((Object)a2, (Object)b));
        Assert.assertFalse((boolean)ClassUtils.equal(null, (Object)b));
        Assert.assertFalse((boolean)ClassUtils.equal((Object)b, (Object)a1));
        Assert.assertFalse((boolean)ClassUtils.equal((Object)b, (Object)a2));
        Assert.assertFalse((boolean)ClassUtils.equal((Object)b, null));
    }

    @Test
    public void testHash() {
        HashBlob a = new HashBlob(1);
        HashBlob b = new HashBlob(2);
        Assert.assertTrue((ClassUtils.hash((Object[])new Object[]{a, b, a, b}) == ClassUtils.hash((Object[])new Object[]{a, b, a, b}) ? 1 : 0) != 0);
        Assert.assertFalse((ClassUtils.hash((Object[])new Object[]{a, b, a}) == ClassUtils.hash((Object[])new Object[]{a, b, a, b}) ? 1 : 0) != 0);
        Assert.assertFalse((ClassUtils.hash((Object[])new Object[]{a, b, a, a}) == ClassUtils.hash((Object[])new Object[]{a, b, a, b}) ? 1 : 0) != 0);
        Assert.assertFalse((ClassUtils.hash((Object[])new Object[]{b, a, b, a}) == ClassUtils.hash((Object[])new Object[]{a, b, a, b}) ? 1 : 0) != 0);
    }

    @Test
    public void testClassTypesWithNullInArray() {
        Object[] array = new Object[]{"hello", null, "world"};
        Class[] classTypes = ClassUtils.getClassTypes((Object)array);
        Assert.assertEquals((long)3L, (long)classTypes.length);
        Assert.assertEquals(String.class, (Object)classTypes[0]);
        Assert.assertEquals(null, (Object)classTypes[1]);
        Assert.assertEquals(String.class, (Object)classTypes[2]);
    }

    @Test
    public void testCompareWithNull() {
        Class[] c1 = new Class[]{String.class, Integer.class};
        Class[] c2 = new Class[]{String.class, null};
        Assert.assertFalse((boolean)ClassUtils.compare((Class[])c1, (Class[])c2, (boolean)true));
        Assert.assertFalse((boolean)ClassUtils.compare((Class[])c2, (Class[])c1, (boolean)true));
    }

    private void simpleNameHelper(String target, Class clazz) {
        Assert.assertEquals((Object)target, (Object)ClassUtils.getSimpleName((Class)clazz));
    }

    private static class HashBlob {
        private int hash;

        public HashBlob(int hash) {
            this.hash = hash;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object other) {
            if (null == other || !this.getClass().equals(other.getClass())) {
                return false;
            }
            return this.hash == ((HashBlob)other).hash;
        }
    }

    private static class DummyObject {
        private DummyObject() {
        }

        public void doSomething(Object object) {
        }

        public Object doSomethingElse(Object object) {
            return object;
        }
    }
}

