/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.util.MapCombiner;

public class MapCombinerTestCase
extends AbstractMuleTestCase {
    @Test
    public void testBasicMerge() {
        this.doTestMerge(new MapCombiner(), "[a:[b:B,c:C]]", "[a:[d:D]]", "[a:[b:B,c:C,d:D]]");
    }

    @Test
    public void testOverwrite() {
        MapCombiner combiner = new MapCombiner();
        combiner.setMaxDepth(0);
        this.doTestMerge(combiner, "[a:[b:B,c:C]]", "[a:[d:D]]", "[a:[d:D]]");
    }

    @Test
    public void testDeepMerge() {
        this.doTestMerge(new MapCombiner(), "[a:[b:B,c:C,d:[e:E,f:F]]]", "[a:[d:[g:G]]]", "[a:[b:B,c:C,d:[e:E,f:F,g:G]]]");
    }

    @Test
    public void testRestrictedMerge() {
        MapCombiner combiner = new MapCombiner();
        combiner.setMaxDepth(1);
        this.doTestMerge(combiner, "[a:[b:B,c:C,d:[e:E,f:F]]]", "[a:[d:[g:G]]]", "[a:[b:B,c:C,d:[g:G]]]");
    }

    @Test
    public void testMergeLists() {
        this.doTestMerge(new MapCombiner(), "[a:(b,c)]", "[a:(d)]", "[a:(b,c,d)]");
    }

    protected void doTestMerge(MapCombiner combiner, String spec1, String spec2, String specResult) {
        Map map1 = MapCombinerTestCase.buildMap(spec1);
        Map map2 = MapCombinerTestCase.buildMap(spec2);
        Map map3 = MapCombinerTestCase.buildMap(specResult);
        combiner.setList(new LinkedList());
        combiner.getList().add(map1);
        combiner.getList().add(map2);
        Assert.assertFalse((boolean)combiner.isEmpty());
        Assert.assertEquals((Object)combiner, (Object)map3);
    }

    @Test
    public void testInfrastructure() {
        Map map = MapCombinerTestCase.buildMap("[a:(b,c)]");
        Assert.assertTrue((boolean)(map.get("a") instanceof List));
        List list = (List)map.get("a");
        Assert.assertTrue((boolean)list.contains("b"));
        Assert.assertTrue((boolean)list.contains("c"));
    }

    public static Map buildMap(String spec) {
        HashMap map = new HashMap();
        String empty = MapCombinerTestCase.fillMap(map, spec);
        Assert.assertTrue((String)("after parsing " + spec + " left with " + empty), (boolean)empty.equals(""));
        return map;
    }

    protected static String fillMap(Map map, String spec) {
        spec = MapCombinerTestCase.drop(spec, "[");
        while (!spec.startsWith("]")) {
            Object value;
            Assert.assertTrue((String)"spec finished early (missing ']'?)", (spec.length() > 1 ? 1 : 0) != 0);
            String key = spec.substring(0, 1);
            spec = MapCombinerTestCase.drop(spec, key);
            spec = MapCombinerTestCase.drop(spec, ":");
            if (spec.startsWith("[")) {
                value = new HashMap();
                spec = MapCombinerTestCase.fillMap(value, spec);
                map.put(key, value);
            } else if (spec.startsWith("(")) {
                value = new LinkedList();
                spec = MapCombinerTestCase.fillList(value, spec);
                map.put(key, value);
            } else {
                value = spec.substring(0, 1);
                spec = MapCombinerTestCase.drop(spec, (String)value);
                map.put(key, value);
            }
            if (!spec.startsWith(",")) continue;
            spec = MapCombinerTestCase.drop(spec, ",");
        }
        return MapCombinerTestCase.drop(spec, "]");
    }

    protected static String fillList(List list, String spec) {
        spec = MapCombinerTestCase.drop(spec, "(");
        while (!spec.startsWith(")")) {
            Object value;
            Assert.assertTrue((String)"spec finished early (missing ')'?)", (spec.length() > 1 ? 1 : 0) != 0);
            if (spec.startsWith("[")) {
                value = new HashMap();
                spec = MapCombinerTestCase.fillMap(value, spec);
                list.add(value);
            } else if (spec.startsWith("(")) {
                value = new LinkedList();
                spec = MapCombinerTestCase.fillList(value, spec);
                list.add(value);
            } else {
                value = spec.substring(0, 1);
                spec = MapCombinerTestCase.drop(spec, (String)value);
                list.add(value);
            }
            if (!spec.startsWith(",")) continue;
            spec = MapCombinerTestCase.drop(spec, ",");
        }
        return MapCombinerTestCase.drop(spec, ")");
    }

    protected static String drop(String spec, String delim) {
        Assert.assertTrue((String)("expected " + delim + " but spec is " + spec), (boolean)spec.startsWith(delim));
        return spec.substring(1);
    }
}

