/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.util.MapUtils;
import org.mule.util.SystemUtils;

public class SystemUtilsTestCase
extends AbstractMuleTestCase {
    @Test
    public void testEnvironment() throws Exception {
        String term;
        String envVarToTest;
        Map env = SystemUtils.getenv();
        Assert.assertNotNull((Object)env);
        Assert.assertFalse((boolean)env.isEmpty());
        Assert.assertSame((Object)env, (Object)SystemUtils.getenv());
        String string = envVarToTest = SystemUtils.IS_OS_WINDOWS ? "Path" : "PATH";
        if (SystemUtils.IS_OS_WINDOWS && (term = (String)env.get("TERM")) != null && term.contains("cygwin")) {
            envVarToTest = "PATH";
        }
        Assert.assertNotNull(env.get(envVarToTest));
    }

    @Test
    public void testParsePropertyDefinitions() {
        Map expected = Collections.EMPTY_MAP;
        Assert.assertEquals((Object)expected, (Object)SystemUtils.parsePropertyDefinitions(null));
        Assert.assertEquals((Object)expected, (Object)SystemUtils.parsePropertyDefinitions((String)""));
        Assert.assertEquals((Object)expected, (Object)SystemUtils.parsePropertyDefinitions((String)" "));
        Assert.assertEquals((Object)expected, (Object)SystemUtils.parsePropertyDefinitions((String)"foo"));
        Assert.assertEquals((Object)expected, (Object)SystemUtils.parsePropertyDefinitions((String)"-D"));
        Assert.assertEquals((Object)expected, (Object)SystemUtils.parsePropertyDefinitions((String)"-D="));
        expected = Collections.singletonMap("-D", "true");
        Assert.assertEquals(expected, (Object)SystemUtils.parsePropertyDefinitions((String)"-D-D"));
        expected = Collections.singletonMap("-D-D", "true");
        Assert.assertEquals(expected, (Object)SystemUtils.parsePropertyDefinitions((String)"-D-D-D"));
        expected = Collections.singletonMap("-D-D-D", "true");
        Assert.assertEquals(expected, (Object)SystemUtils.parsePropertyDefinitions((String)"-D-D-D-D"));
        Assert.assertEquals((Object)Collections.EMPTY_MAP, (Object)SystemUtils.parsePropertyDefinitions((String)"-D=noKey"));
        Assert.assertEquals((Object)Collections.EMPTY_MAP, (Object)SystemUtils.parsePropertyDefinitions((String)"=-D"));
        Assert.assertEquals((Object)Collections.EMPTY_MAP, (Object)SystemUtils.parsePropertyDefinitions((String)"foo =foo foo"));
        expected = Collections.singletonMap("k", "true");
        Assert.assertEquals(expected, (Object)SystemUtils.parsePropertyDefinitions((String)" -Dk "));
        expected = Collections.singletonMap("key", "true");
        Assert.assertEquals(expected, (Object)SystemUtils.parsePropertyDefinitions((String)"-Dkey"));
        expected = Collections.singletonMap("k", "v");
        Assert.assertEquals(expected, (Object)SystemUtils.parsePropertyDefinitions((String)" -Dk=v "));
        expected = Collections.singletonMap("key", "value");
        Assert.assertEquals(expected, (Object)SystemUtils.parsePropertyDefinitions((String)"-Dkey=value"));
        expected = Collections.singletonMap("key", "quoted");
        Assert.assertEquals(expected, (Object)SystemUtils.parsePropertyDefinitions((String)"-Dkey=\"quoted\""));
        expected = MapUtils.mapWithKeysAndValues(HashMap.class, (Object[])new String[]{"key", "foo"}, (Object[])new String[]{"-Dvalue", "bar"});
        Assert.assertEquals((Object)expected, (Object)SystemUtils.parsePropertyDefinitions((String)"-Dkey=-Dvalue -Dfoo=bar"));
        Assert.assertEquals((Object)Collections.EMPTY_MAP, (Object)SystemUtils.parsePropertyDefinitions((String)"-D=-Dfoo-D== =foo"));
        expected = Collections.singletonMap("key", "split value");
        Assert.assertEquals(expected, (Object)SystemUtils.parsePropertyDefinitions((String)"-Dkey=\"split value\""));
        expected = MapUtils.mapWithKeysAndValues(HashMap.class, (Object[])new String[]{"key1", "key2"}, (Object[])new String[]{"split one", "split two"});
        String input = "-Dkey1=\"split one\" -Dkey2=\"split two\" ";
        Assert.assertEquals((Object)expected, (Object)SystemUtils.parsePropertyDefinitions((String)input));
        expected = Collections.singletonMap("key", "open end");
        input = "-Dkey=\"open end";
        Assert.assertEquals(expected, (Object)SystemUtils.parsePropertyDefinitions((String)input));
        expected = MapUtils.mapWithKeysAndValues(HashMap.class, (Object[])new String[]{"keyOnly", "mule.foo", "mule.bar"}, (Object[])new String[]{"true", "xfoo", "xbar"});
        input = "  standalone key=value -D -D= -DkeyOnly -D=noKey -Dmule.foo=xfoo -Dmule.bar=xbar ";
        Assert.assertEquals((Object)expected, (Object)SystemUtils.parsePropertyDefinitions((String)input));
    }
}

