/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.util.TemplateParser;

public class TemplateParserTestCase
extends AbstractMuleTestCase {
    @Test
    public void testStringParserSquareBraces() {
        TemplateParser tp = TemplateParser.createSquareBracesStyleParser();
        Assert.assertNotNull((Object)tp.getStyle());
        Assert.assertEquals((Object)"[", (Object)tp.getStyle().getPrefix());
        Assert.assertEquals((Object)"]", (Object)tp.getStyle().getSuffix());
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("fromAddress", "ross.mason@symphonysoft.com");
        String string = "smtp://[fromAddress]";
        String result = tp.parse(props, string);
        Assert.assertEquals((Object)"smtp://ross.mason@symphonysoft.com", (Object)result);
        string = "smtp://[toAddress]";
        result = tp.parse(props, string);
        Assert.assertEquals((Object)"smtp://[toAddress]", (Object)result);
    }

    @Test
    public void testParserValidationSquareBraces() {
        TemplateParser tp = TemplateParser.createSquareBracesStyleParser();
        Assert.assertTrue((boolean)tp.isValid("[][]"));
        Assert.assertTrue((boolean)tp.isValid("[[]]"));
        Assert.assertFalse((boolean)tp.isValid("[[][]"));
    }

    @Test
    public void testParserValidationAntStyle() {
        TemplateParser tp = TemplateParser.createAntStyleParser();
        Assert.assertTrue((boolean)tp.isValid("${}"));
        Assert.assertTrue((boolean)tp.isValid("${}${}"));
        Assert.assertFalse((boolean)tp.isValid("${}&{}"));
        Assert.assertFalse((boolean)tp.isValid("{}${}"));
        Assert.assertTrue((boolean)tp.isValid("${$}${}"));
        Assert.assertFalse((boolean)tp.isValid("${${}}${}"));
        Assert.assertFalse((boolean)tp.isValid("$ {}"));
    }

    @Test
    public void testParserValidationMuleStyle() {
        TemplateParser tp = TemplateParser.createMuleStyleParser();
        Assert.assertTrue((boolean)tp.isValid("#[]"));
        Assert.assertTrue((boolean)tp.isValid("#[]   #[]"));
        Assert.assertFalse((boolean)tp.isValid("#[]&[]"));
        Assert.assertFalse((boolean)tp.isValid("[]$[]#"));
        Assert.assertTrue((boolean)tp.isValid("#[#]#[]"));
        Assert.assertFalse((boolean)tp.isValid("#[#[]]#[]"));
        Assert.assertFalse((boolean)tp.isValid("# []"));
        Assert.assertTrue((boolean)tp.isValid("#[foo:blah[4] = 'foo']"));
        Assert.assertTrue((boolean)tp.isValid("#[foo:blah[4] = '#foo']"));
        Assert.assertFalse((boolean)tp.isValid("#[foo:blah4] = '#foo']"));
        Assert.assertFalse((boolean)tp.isValid("#[foo:blah = '#[foo]']"));
    }

    @Test
    public void testStringParserAntBraces() {
        TemplateParser tp = TemplateParser.createAntStyleParser();
        Assert.assertNotNull((Object)tp.getStyle());
        Assert.assertEquals((Object)"${", (Object)tp.getStyle().getPrefix());
        Assert.assertEquals((Object)"}", (Object)tp.getStyle().getSuffix());
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("prop1", "value1");
        props.put("prop2", "value2");
        String string = "Some String with ${prop1} and ${prop2} in it";
        String result = tp.parse(props, string);
        Assert.assertEquals((Object)"Some String with value1 and value2 in it", (Object)result);
        string = "${prop1}${prop1}${prop2}";
        result = tp.parse(props, string);
        Assert.assertEquals((Object)"value1value1value2", (Object)result);
        String homeDir = System.getProperty("user.home");
        props.put("homeDir", homeDir);
        string = "${homeDir}/foo";
        result = tp.parse(props, string);
        Assert.assertEquals((Object)(homeDir + "/foo"), (Object)result);
        String whitespaceValue = "C:\\Documents and Settings\\";
        props.put("whitespaceValue", whitespaceValue);
        string = "start${whitespaceValue}end";
        result = tp.parse(props, string);
        Assert.assertEquals((Object)("start" + whitespaceValue + "end"), (Object)result);
    }

    @Test
    public void testListParserAntBraces() {
        TemplateParser tp = TemplateParser.createAntStyleParser();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("prop1", "value1");
        props.put("prop2", "value2");
        ArrayList<String> list = new ArrayList<String>();
        list.add("Some String with ${prop1} and ${prop2} in it");
        list.add("Some String with ${prop1} in it");
        List result = tp.parse(props, list);
        Assert.assertEquals((Object)"Some String with value1 and value2 in it", result.get(0));
        Assert.assertEquals((Object)"Some String with value1 in it", result.get(1));
        result = tp.parse(props, (List)null);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testMapParserAntBraces() {
        TemplateParser tp = TemplateParser.createAntStyleParser();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("prop1", "value1");
        props.put("prop2", "value2");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("value1", "Some String with ${prop1} and ${prop2} in it");
        map.put("value2", "Some String with ${prop1} in it");
        Map result = tp.parse(props, map);
        Assert.assertEquals((Object)"Some String with value1 and value2 in it", result.get("value1"));
        Assert.assertEquals((Object)"Some String with value1 in it", result.get("value2"));
        result = tp.parse(props, (Map)null);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testStringParserAntBracesWithSimilarNames() {
        TemplateParser tp = TemplateParser.createAntStyleParser();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("prop1", "value1");
        props.put("prop1-2", "value2");
        String string = "Some String with ${prop1} and ${prop1-2} in it";
        String result = tp.parse(props, string);
        Assert.assertEquals((Object)"Some String with value1 and value2 in it", (Object)result);
        string = "A${prop1-2}B${prop1}C${prop2}";
        result = tp.parse(props, string);
        Assert.assertEquals((Object)"Avalue2Bvalue1C${prop2}", (Object)result);
    }
}

