/*
 * Decompiled with CFR 0.152.
 */
package org.ibeans.impl.view;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.ibeans.annotation.Call;
import org.ibeans.annotation.State;
import org.ibeans.annotation.Template;
import org.ibeans.annotation.Usage;
import org.ibeans.annotation.param.Attachment;
import org.ibeans.annotation.param.Body;
import org.ibeans.annotation.param.BodyParam;
import org.ibeans.annotation.param.HeaderParam;
import org.ibeans.annotation.param.Optional;
import org.ibeans.annotation.param.PropertyParam;
import org.ibeans.annotation.param.ReturnType;
import org.ibeans.annotation.param.UriParam;
import org.ibeans.api.ClientAuthentication;
import org.ibeans.api.IBeanView;
import org.ibeans.impl.IBeansNotationHelper;
import org.ibeans.impl.support.annotation.AnnotationMetaData;
import org.ibeans.impl.support.annotation.AnnotationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TemplateView
implements IBeanView {
    private Class ibeanClass;
    private String usage;
    private String shortId;
    private boolean authentication;
    List<AnnotationMetaData> calls = new ArrayList<AnnotationMetaData>();
    List<AnnotationMetaData> templates = new ArrayList<AnnotationMetaData>();
    List<AnnotationMetaData> stateCalls = new ArrayList<AnnotationMetaData>();
    List<AnnotationMetaData> authCalls = new ArrayList<AnnotationMetaData>();
    List<FieldAnnotation> fields = new ArrayList<FieldAnnotation>();

    @Override
    public String createView(Class ibean) {
        this.ibeanClass = ibean;
        AnnotationMetaData anno = AnnotationUtils.getClassAnnotationInHeirarchy(Usage.class, ibean);
        if (anno != null) {
            this.usage = ((Usage)anno.getAnnotation()).value();
        }
        this.shortId = IBeansNotationHelper.getIBeanShortID(ibean);
        this.authentication = ClientAuthentication.class.isAssignableFrom(ibean);
        for (int i = 0; i < ibean.getMethods().length; ++i) {
            Method method = ibean.getMethods()[i];
            if (method.isAnnotationPresent(Call.class)) {
                this.calls.add(new AnnotationMetaData(this.ibeanClass, method, ElementType.METHOD, method.getAnnotation(Call.class)));
                continue;
            }
            if (method.isAnnotationPresent(Template.class)) {
                this.templates.add(new AnnotationMetaData(this.ibeanClass, method, ElementType.METHOD, method.getAnnotation(Template.class)));
                continue;
            }
            if (!method.isAnnotationPresent(State.class)) continue;
            this.stateCalls.add(new AnnotationMetaData(this.ibeanClass, method, ElementType.METHOD, method.getAnnotation(State.class)));
        }
        Set<AnnotationMetaData> flds = AnnotationUtils.getFieldAnnotationsForHeirarchy(ibean);
        for (AnnotationMetaData field : flds) {
            Field f = (Field)field.getMember();
            f.setAccessible(true);
            Object value = null;
            try {
                value = f.get(ibean);
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
            if (field.getAnnotation() instanceof UriParam) {
                UriParam uriParam = (UriParam)field.getAnnotation();
                this.fields.add(new FieldAnnotation("@UriParam", f.getType(), f.getName(), value, uriParam.value(), uriParam));
            }
            if (field.getAnnotation() instanceof HeaderParam) {
                HeaderParam headerParam = (HeaderParam)field.getAnnotation();
                this.fields.add(new FieldAnnotation("@HeaderParam", f.getType(), f.getName(), value, headerParam.value(), headerParam));
            }
            if (field.getAnnotation() instanceof PropertyParam) {
                PropertyParam propertyParam = (PropertyParam)field.getAnnotation();
                this.fields.add(new FieldAnnotation("@PropertyParam", f.getType(), f.getName(), value, propertyParam.value(), propertyParam));
            }
            if (!(field.getAnnotation() instanceof ReturnType)) continue;
            this.fields.add(new FieldAnnotation("@ReturnType", f.getType(), f.getName(), null, null, field.getAnnotation()));
        }
        return null;
    }

    public List<AnnotationParam> listParams(Method method) {
        ArrayList<AnnotationParam> params = new ArrayList<AnnotationParam>();
        if (method.getParameterAnnotations().length > 0 && method.getParameterAnnotations()[0].length > 0) {
            for (int i = 0; i < method.getParameterAnnotations().length; ++i) {
                Annotation param;
                Annotation annotation = method.getParameterAnnotations()[i][0];
                boolean optional = false;
                if (annotation.annotationType().equals(Optional.class)) {
                    optional = true;
                    annotation = method.getParameterAnnotations()[i][1];
                }
                if (annotation.annotationType().equals(UriParam.class)) {
                    param = (UriParam)annotation;
                    params.add(new AnnotationParam(param.value(), method.getParameterTypes()[i], param, optional));
                    continue;
                }
                if (annotation.annotationType().equals(HeaderParam.class)) {
                    param = (HeaderParam)annotation;
                    params.add(new AnnotationParam(param.value(), method.getParameterTypes()[i], param, optional));
                    continue;
                }
                if (annotation.annotationType().equals(PropertyParam.class)) {
                    param = (PropertyParam)annotation;
                    params.add(new AnnotationParam(param.value(), method.getParameterTypes()[i], param, optional));
                    continue;
                }
                if (annotation.annotationType().equals(BodyParam.class)) {
                    param = (BodyParam)annotation;
                    params.add(new AnnotationParam(param.value(), method.getParameterTypes()[i], param, optional));
                    continue;
                }
                if (annotation.annotationType().equals(Body.class)) {
                    params.add(new AnnotationParam("[Payload]", method.getParameterTypes()[i], annotation, optional));
                    continue;
                }
                if (annotation.annotationType().equals(ReturnType.class)) {
                    params.add(new AnnotationParam("[ReturnType]", method.getParameterTypes()[i], annotation, optional));
                    continue;
                }
                if (!annotation.annotationType().equals(Attachment.class)) continue;
                params.add(new AnnotationParam("[attachment]", method.getParameterTypes()[i], annotation, optional));
            }
        }
        return params;
    }

    public Class getIbeanClass() {
        return this.ibeanClass;
    }

    public String getUsage() {
        return this.usage;
    }

    public String getShortId() {
        return this.shortId;
    }

    public boolean isAuthentication() {
        return this.authentication;
    }

    public List<AnnotationMetaData> getCalls() {
        return this.calls;
    }

    public List<AnnotationMetaData> getTemplates() {
        return this.templates;
    }

    public List<AnnotationMetaData> getStateCalls() {
        return this.stateCalls;
    }

    public List<AnnotationMetaData> getAuthCalls() {
        return this.authCalls;
    }

    public List<FieldAnnotation> getFields() {
        return this.fields;
    }

    public class FieldAnnotation {
        private String prefix;
        private Annotation annotation;
        private String fieldName;
        private Object fieldValue;
        private Class fieldType;
        private String paramName;

        public FieldAnnotation(String prefix, Class fieldType, String fieldName, Object fieldValue, String paramName, Annotation annotation) {
            this.prefix = prefix;
            this.annotation = annotation;
            this.fieldName = fieldName;
            this.fieldValue = fieldValue;
            this.paramName = paramName;
            this.fieldType = fieldType;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public Annotation getAnnotation() {
            return this.annotation;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public Object getFieldValue() {
            return this.fieldValue;
        }

        public String getParamName() {
            return this.paramName;
        }

        public Class getFieldType() {
            return this.fieldType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AnnotationParam {
        private String name;
        private Annotation annotation;
        private boolean optional = false;
        private Class<?> paramType;

        public AnnotationParam(String name, Class<?> paramType, Annotation annotation, boolean optional) {
            this.name = name;
            this.annotation = annotation;
            this.optional = optional;
            this.paramType = paramType;
        }

        public String getName() {
            return this.name;
        }

        public Annotation getAnnotation() {
            return this.annotation;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public Class getParamType() {
            return this.paramType;
        }
    }
}

