/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.bouncycastle.apache.bzip2.CBZip2OutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.CompressionAlgorithmTags;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.StreamGenerator;
import org.bouncycastle.openpgp.WrappedGeneratorStream;

public class PGPCompressedDataGenerator
implements CompressionAlgorithmTags,
StreamGenerator {
    private int algorithm;
    private int compression;
    private OutputStream out;
    private OutputStream dOut;
    private BCPGOutputStream pkOut;

    public PGPCompressedDataGenerator(int n) {
        this(n, -1);
    }

    public PGPCompressedDataGenerator(int n, int n2) {
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            throw new IllegalArgumentException("unknown compression algorithm");
        }
        if (n2 != -1 && (n2 < 0 || n2 > 9)) {
            throw new IllegalArgumentException("unknown compression level: " + n2);
        }
        this.algorithm = n;
        this.compression = n2;
    }

    public OutputStream open(OutputStream outputStream) throws IOException {
        if (this.dOut != null) {
            throw new IllegalStateException("generator already in open state");
        }
        this.out = outputStream;
        switch (this.algorithm) {
            case 1: {
                this.pkOut = new BCPGOutputStream(outputStream, 8);
                this.pkOut.write(1);
                this.dOut = new DeflaterOutputStream((OutputStream)this.pkOut, new Deflater(this.compression, true));
                break;
            }
            case 2: {
                this.pkOut = new BCPGOutputStream(outputStream, 8);
                this.pkOut.write(2);
                this.dOut = new DeflaterOutputStream((OutputStream)this.pkOut, new Deflater(this.compression));
                break;
            }
            case 3: {
                this.pkOut = new BCPGOutputStream(outputStream, 8);
                this.pkOut.write(3);
                this.dOut = new CBZip2OutputStream(this.pkOut);
                break;
            }
            case 0: {
                this.pkOut = new BCPGOutputStream(outputStream, 8);
                this.pkOut.write(0);
                this.dOut = this.pkOut;
                break;
            }
            default: {
                throw new IllegalStateException("generator not initialised");
            }
        }
        return new WrappedGeneratorStream(this.dOut, this);
    }

    public OutputStream open(OutputStream outputStream, byte[] byArray) throws IOException, PGPException {
        if (this.dOut != null) {
            throw new IllegalStateException("generator already in open state");
        }
        this.out = outputStream;
        switch (this.algorithm) {
            case 1: {
                this.pkOut = new BCPGOutputStream(outputStream, 8, byArray);
                this.pkOut.write(1);
                this.dOut = new DeflaterOutputStream((OutputStream)this.pkOut, new Deflater(this.compression, true));
                break;
            }
            case 2: {
                this.pkOut = new BCPGOutputStream(outputStream, 8, byArray);
                this.pkOut.write(2);
                this.dOut = new DeflaterOutputStream((OutputStream)this.pkOut, new Deflater(this.compression));
                break;
            }
            case 3: {
                this.pkOut = new BCPGOutputStream(outputStream, 8, byArray);
                this.pkOut.write(3);
                this.dOut = new CBZip2OutputStream(this.pkOut);
                break;
            }
            case 0: {
                this.pkOut = new BCPGOutputStream(outputStream, 8, byArray);
                this.pkOut.write(0);
                this.dOut = this.pkOut;
                break;
            }
            default: {
                throw new IllegalStateException("generator not initialised");
            }
        }
        return new WrappedGeneratorStream(this.dOut, this);
    }

    @Override
    public void close() throws IOException {
        if (this.dOut != null) {
            if (this.dOut instanceof DeflaterOutputStream) {
                DeflaterOutputStream deflaterOutputStream = (DeflaterOutputStream)this.dOut;
                deflaterOutputStream.finish();
            } else if (this.dOut instanceof CBZip2OutputStream) {
                CBZip2OutputStream cBZip2OutputStream = (CBZip2OutputStream)this.dOut;
                cBZip2OutputStream.finish();
            }
            this.dOut.flush();
            this.pkOut.finish();
            this.pkOut.flush();
            this.out.flush();
            this.dOut = null;
            this.pkOut = null;
            this.out = null;
        }
    }
}

