/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transaction;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleRuntimeException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.transaction.TransactionConfig;
import org.mule.api.transaction.TransactionFactory;
import org.mule.config.i18n.CoreMessages;
import org.mule.transaction.TransactionCoordination;
import org.mule.transaction.constraints.ConstraintFilter;
import org.mule.util.ClassUtils;

public class MuleTransactionConfig
implements TransactionConfig,
MuleContextAware {
    protected static final Log logger = LogFactory.getLog(MuleTransactionConfig.class);
    public static final String ACTION_NONE_STRING = "NONE";
    public static final String ACTION_ALWAYS_BEGIN_STRING = "ALWAYS_BEGIN";
    public static final String ACTION_BEGIN_OR_JOIN_STRING = "BEGIN_OR_JOIN";
    public static final String ACTION_ALWAYS_JOIN_STRING = "ALWAYS_JOIN";
    public static final String ACTION_JOIN_IF_POSSIBLE_STRING = "JOIN_IF_POSSIBLE";
    public static final String ACTION_NEVER_STRING = "NEVER";
    public static final String ACTION_INDIFFERENT_STRING = "INDIFFERENT";
    private TransactionFactory factory;
    private byte action = (byte)6;
    private ConstraintFilter constraint = null;
    private Integer timeout;
    private boolean interactWithExternal = false;

    public MuleTransactionConfig() {
    }

    public MuleTransactionConfig(byte action) {
        this.action = action;
    }

    @Override
    public void setMuleContext(MuleContext context) {
        if (this.timeout == null) {
            this.timeout = context.getConfiguration().getDefaultTransactionTimeout();
        }
    }

    @Override
    public TransactionFactory getFactory() {
        return this.factory;
    }

    @Override
    public void setFactory(TransactionFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Transaction Factory cannot be null");
        }
        this.factory = factory;
    }

    @Override
    public byte getAction() {
        return this.action;
    }

    @Override
    public void setAction(byte action) {
        this.action = action;
    }

    @Override
    public boolean isInteractWithExternal() {
        return this.interactWithExternal;
    }

    @Override
    public void setInteractWithExternal(boolean interactWithExternal) {
        this.interactWithExternal = interactWithExternal;
    }

    public void setActionAsString(String action) {
        if (ACTION_ALWAYS_BEGIN_STRING.equals(action)) {
            this.action = 1;
        } else if (ACTION_BEGIN_OR_JOIN_STRING.equals(action)) {
            this.action = (byte)2;
        } else if (ACTION_ALWAYS_JOIN_STRING.equals(action)) {
            this.action = (byte)3;
        } else if (ACTION_JOIN_IF_POSSIBLE_STRING.equals(action)) {
            this.action = (byte)4;
        } else if (ACTION_NONE_STRING.equals(action)) {
            this.action = 0;
        } else if (ACTION_NEVER_STRING.equals(action)) {
            this.action = (byte)5;
        } else if (ACTION_INDIFFERENT_STRING.equals(action)) {
            this.action = (byte)6;
        } else {
            throw new IllegalArgumentException("Action " + action + " is not recognised as a begin action.");
        }
    }

    public String getActionAsString() {
        switch (this.action) {
            case 1: {
                return ACTION_ALWAYS_BEGIN_STRING;
            }
            case 2: {
                return ACTION_BEGIN_OR_JOIN_STRING;
            }
            case 3: {
                return ACTION_ALWAYS_JOIN_STRING;
            }
            case 4: {
                return ACTION_JOIN_IF_POSSIBLE_STRING;
            }
            case 0: {
                return ACTION_NONE_STRING;
            }
            case 6: {
                return ACTION_INDIFFERENT_STRING;
            }
        }
        return ACTION_NEVER_STRING;
    }

    @Override
    public boolean isTransacted() {
        if (this.action == 5 || this.action == 0) {
            return false;
        }
        if (this.factory == null) {
            if (this.action != 6) {
                throw new MuleRuntimeException(CoreMessages.transactionFactoryIsMandatory(this.getActionAsString()));
            }
        } else if (!this.factory.isTransacted()) {
            return false;
        }
        switch (this.action) {
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
            case 4: 
            case 6: {
                return TransactionCoordination.getInstance().getTransaction() != null;
            }
        }
        return false;
    }

    @Override
    public boolean isConfigured() {
        return this.factory != null;
    }

    @Override
    public ConstraintFilter getConstraint() {
        if (this.constraint == null) {
            return null;
        }
        try {
            return (ConstraintFilter)this.constraint.clone();
        }
        catch (CloneNotSupportedException e) {
            logger.fatal((Object)("Failed to clone ConstraintFilter: " + e.getMessage()), (Throwable)e);
            return this.constraint;
        }
    }

    @Override
    public void setConstraint(ConstraintFilter constraint) {
        this.constraint = constraint;
    }

    @Override
    public int getTimeout() {
        return this.timeout == null ? 0 : this.timeout;
    }

    @Override
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Transaction{factory=").append(this.factory).append(", action=").append(this.getActionAsString()).append(", timeout=").append(this.timeout == null ? 0 : this.timeout).append("}");
        return buf.toString();
    }

    public int hashCode() {
        return ClassUtils.hash(new Object[]{this.factory, this.action, this.constraint, this.timeout == null ? 0 : this.timeout});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MuleTransactionConfig other = (MuleTransactionConfig)obj;
        return ClassUtils.equal(this.factory, other.factory) && ClassUtils.equal(this.action, other.action) && ClassUtils.equal(this.constraint, other.constraint) && ClassUtils.equal(this.timeout, other.timeout);
    }
}

