/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.xml.namespace.QName;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.AnnotatedObject;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.context.notification.MuleContextNotificationListener;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transformer.TransformerMessagingException;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.Message;
import org.mule.context.notification.MuleContextNotification;
import org.mule.context.notification.NotificationException;
import org.mule.transformer.AbstractMessageTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transformer.types.SimpleDataType;
import org.mule.transport.NullPayload;
import org.mule.util.ClassUtils;
import org.mule.util.StringMessageUtils;
import org.mule.util.StringUtils;

public abstract class AbstractTransformer
implements Transformer,
MuleContextNotificationListener<MuleContextNotification>,
AnnotatedObject {
    public static final DataType<MuleMessage> MULE_MESSAGE_DATA_TYPE = new SimpleDataType<MuleMessage>(MuleMessage.class);
    protected MuleContext muleContext;
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected DataType<?> returnType = new SimpleDataType(Object.class);
    protected String name = null;
    protected ImmutableEndpoint endpoint = null;
    protected final List<DataType<?>> sourceTypes = new CopyOnWriteArrayList();
    private boolean ignoreBadInput = false;
    private boolean allowNullReturn = false;
    protected String mimeType;
    protected String encoding;
    private final Map<QName, Object> annotations = new ConcurrentHashMap<QName, Object>();

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        if (event != null && event.getMessage() != null) {
            try {
                event.getMessage().applyTransformers(event, this);
            }
            catch (Exception e) {
                throw new TransformerMessagingException(event, this, (Throwable)e);
            }
        }
        return event;
    }

    protected Object checkReturnClass(Object object) throws TransformerException {
        DataType<?> dt;
        if (object == null || object instanceof NullPayload && this.isAllowNullReturn()) {
            return object;
        }
        if (this.returnType != null && !this.returnType.isCompatibleWith(dt = DataTypeFactory.create(object.getClass()))) {
            throw new TransformerException(CoreMessages.transformUnexpectedType(dt, this.returnType), this);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("The transformed object is of expected type. Type is: " + ClassUtils.getSimpleName(object.getClass())));
        }
        return object;
    }

    @Deprecated
    protected void registerSourceType(Class<?> aClass) {
        this.registerSourceType(new SimpleDataType(aClass));
    }

    @Deprecated
    protected void unregisterSourceType(Class<?> aClass) {
        this.unregisterSourceType(new SimpleDataType(aClass));
    }

    protected void registerSourceType(DataType<?> dataType) {
        if (!this.sourceTypes.contains(dataType)) {
            this.sourceTypes.add(dataType);
            if (dataType.getType().equals(Object.class)) {
                this.logger.debug((Object)"java.lang.Object has been added as source type for this transformer, there will be no source type checking performed");
            }
        }
    }

    protected void unregisterSourceType(DataType<?> dataType) {
        this.sourceTypes.remove(dataType);
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = this.generateTransformerName();
        }
        return this.name;
    }

    @Override
    public void setName(String string) {
        if (string == null) {
            string = ClassUtils.getSimpleName(this.getClass());
        }
        this.logger.debug((Object)("Setting transformer name to: " + string));
        this.name = string;
    }

    @Override
    @Deprecated
    public Class<?> getReturnClass() {
        return this.returnType.getType();
    }

    @Override
    public void setReturnDataType(DataType<?> type) {
        this.returnType = type.cloneDataType();
        this.encoding = type.getEncoding();
        this.mimeType = type.getMimeType();
    }

    @Override
    public DataType<?> getReturnDataType() {
        return this.returnType;
    }

    @Override
    @Deprecated
    public void setReturnClass(Class<?> newClass) {
        SimpleDataType tempReturnType = new SimpleDataType(newClass);
        tempReturnType.setMimeType(this.mimeType);
        tempReturnType.setEncoding(this.encoding);
        this.setReturnDataType(tempReturnType);
    }

    public void setMimeType(String mimeType) throws MimeTypeParseException {
        if (mimeType == null) {
            this.mimeType = null;
        } else {
            MimeType mt = new MimeType(mimeType);
            this.mimeType = mt.getPrimaryType() + "/" + mt.getSubType();
        }
        if (this.returnType != null) {
            this.returnType.setMimeType(mimeType);
        }
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
        if (this.returnType != null) {
            this.returnType.setEncoding(encoding);
        }
    }

    public boolean isAllowNullReturn() {
        return this.allowNullReturn;
    }

    public void setAllowNullReturn(boolean allowNullReturn) {
        this.allowNullReturn = allowNullReturn;
    }

    @Override
    @Deprecated
    public boolean isSourceTypeSupported(Class<?> aClass) {
        return this.isSourceDataTypeSupported(DataTypeFactory.create(aClass), false);
    }

    @Override
    public boolean isSourceDataTypeSupported(DataType<?> dataType) {
        return this.isSourceDataTypeSupported(dataType, false);
    }

    @Deprecated
    public boolean isSourceTypeSupported(Class<MuleMessage> aClass, boolean exactMatch) {
        return this.isSourceDataTypeSupported(new SimpleDataType(aClass), exactMatch);
    }

    public boolean isSourceDataTypeSupported(DataType<?> dataType, boolean exactMatch) {
        int numTypes = this.sourceTypes.size();
        if (numTypes == 0) {
            return !exactMatch;
        }
        for (DataType<?> sourceType : this.sourceTypes) {
            if (!(exactMatch ? sourceType.equals(dataType) : sourceType.isCompatibleWith(dataType))) continue;
            return true;
        }
        return false;
    }

    @Override
    public final Object transform(Object src) throws TransformerException {
        return this.transform(src, this.getEncoding(src));
    }

    @Override
    public Object transform(Object src, String enc) throws TransformerException {
        Object result;
        DataType<?> sourceType;
        Object payload = src;
        if (src instanceof MuleMessage) {
            MuleMessage message = (MuleMessage)src;
            if (!this.isSourceDataTypeSupported(MULE_MESSAGE_DATA_TYPE, true) && !(this instanceof AbstractMessageTransformer)) {
                src = ((MuleMessage)src).getPayload();
                payload = message.getPayload();
            }
        }
        if (!this.isSourceDataTypeSupported(sourceType = DataTypeFactory.create(payload.getClass()))) {
            if (this.ignoreBadInput) {
                this.logger.debug((Object)"Source type is incompatible with this transformer and property 'ignoreBadInput' is set to true, so the transformer chain will continue.");
                return payload;
            }
            Message msg = CoreMessages.transformOnObjectUnsupportedTypeOfEndpoint(this.getName(), payload.getClass(), this.endpoint);
            throw new TransformerException(msg, this);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format("Applying transformer %s (%s)", this.getName(), this.getClass().getName()));
            this.logger.debug((Object)String.format("Object before transform: %s", StringMessageUtils.toString(payload)));
        }
        if ((result = this.doTransform(payload, enc)) == null) {
            result = NullPayload.getInstance();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format("Object after transform: %s", StringMessageUtils.toString(result)));
        }
        result = this.checkReturnClass(result);
        return result;
    }

    protected String getEncoding(Object src) {
        String enc = null;
        if (src instanceof MuleMessage) {
            enc = ((MuleMessage)src).getEncoding();
        }
        if (enc == null && this.endpoint != null) {
            enc = this.endpoint.getEncoding();
        } else if (enc == null) {
            enc = System.getProperty("mule.encoding");
        }
        return enc;
    }

    protected boolean isConsumed(Class<?> srcCls) {
        return InputStream.class.isAssignableFrom(srcCls) || StreamSource.class.isAssignableFrom(srcCls);
    }

    @Override
    public ImmutableEndpoint getEndpoint() {
        return this.endpoint;
    }

    @Override
    public void setEndpoint(ImmutableEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    protected abstract Object doTransform(Object var1, String var2) throws TransformerException;

    @Override
    public void initialise() throws InitialisationException {
    }

    @Override
    public void dispose() {
    }

    protected String generateTransformerName() {
        String transformerName = ClassUtils.getSimpleName(this.getClass());
        int i = transformerName.indexOf("To");
        if (i > 0 && this.returnType != null) {
            String target = ClassUtils.getSimpleName(this.returnType.getType());
            if (target.equals("byte[]")) {
                target = "byteArray";
            }
            transformerName = transformerName.substring(0, i + 2) + StringUtils.capitalize((String)target);
        }
        return transformerName;
    }

    @Override
    @Deprecated
    public List<Class<?>> getSourceTypes() {
        ArrayList sourceClasses = new ArrayList();
        for (DataType<?> sourceType : this.sourceTypes) {
            sourceClasses.add(sourceType.getType());
        }
        return Collections.unmodifiableList(sourceClasses);
    }

    @Override
    public List<DataType<?>> getSourceDataTypes() {
        return Collections.unmodifiableList(this.sourceTypes);
    }

    @Override
    public boolean isIgnoreBadInput() {
        return this.ignoreBadInput;
    }

    public void setIgnoreBadInput(boolean ignoreBadInput) {
        this.ignoreBadInput = ignoreBadInput;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(80);
        sb.append(ClassUtils.getSimpleName(this.getClass()));
        sb.append("{this=").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", ignoreBadInput=").append(this.ignoreBadInput);
        sb.append(", returnClass=").append(this.returnType);
        sb.append(", sourceTypes=").append(this.sourceTypes);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean isAcceptNull() {
        return false;
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
        try {
            this.muleContext.registerListener(this);
        }
        catch (NotificationException e) {
            this.logger.error((Object)"failed to register context listener", (Throwable)e);
        }
    }

    @Override
    public void onNotification(MuleContextNotification notification) {
        if (notification.getAction() == 107) {
            this.dispose();
        }
    }

    @Override
    public final Object getAnnotation(QName name) {
        return this.annotations.get(name);
    }

    @Override
    public final Map<QName, Object> getAnnotations() {
        return Collections.unmodifiableMap(this.annotations);
    }

    @Override
    public final synchronized void setAnnotations(Map<QName, Object> newAnnotations) {
        this.annotations.clear();
        this.annotations.putAll(newAnnotations);
    }
}

