/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.quartz.jobs;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleMessage;
import org.mule.api.ThreadSafeAccess;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.transaction.Transaction;
import org.mule.api.transaction.TransactionCallback;
import org.mule.api.transaction.TransactionConfig;
import org.mule.api.transport.PropertyScope;
import org.mule.module.client.MuleClient;
import org.mule.transaction.MuleTransactionConfig;
import org.mule.transaction.TransactionCoordination;
import org.mule.transaction.TransactionTemplate;
import org.mule.transport.AbstractMessageReceiver;
import org.mule.transport.quartz.QuartzConnector;
import org.mule.transport.quartz.i18n.QuartzMessages;
import org.mule.transport.quartz.jobs.AbstractJob;
import org.mule.transport.quartz.jobs.EndpointPollingJobConfig;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class EndpointPollingJob
extends AbstractJob {
    protected transient Log logger = LogFactory.getLog(this.getClass());

    @Override
    protected void doExecute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        final JobDataMap jobDataMap = jobExecutionContext.getJobDetail().getJobDataMap();
        String receiverKey = (String)jobDataMap.get((Object)"mule.quartz.receiver");
        if (receiverKey == null) {
            throw new JobExecutionException(QuartzMessages.receiverNotInJobDataMap().getMessage());
        }
        String connectorName = (String)jobDataMap.get((Object)"mule.quartz.connector");
        if (connectorName == null) {
            throw new JobExecutionException(QuartzMessages.connectorNotInJobDataMap().getMessage());
        }
        final QuartzConnector connector = (QuartzConnector)this.muleContext.getRegistry().lookupConnector(connectorName);
        if (connector == null) {
            throw new JobExecutionException(QuartzMessages.noConnectorFound(connectorName).getMessage());
        }
        final AbstractMessageReceiver receiver = (AbstractMessageReceiver)connector.lookupReceiver(receiverKey);
        if (receiver == null) {
            throw new JobExecutionException(QuartzMessages.noReceiverInConnector(receiverKey, connectorName).getMessage());
        }
        final EndpointPollingJobConfig jobConfig = (EndpointPollingJobConfig)jobDataMap.get((Object)"jobConfig");
        if (jobConfig == null) {
            throw new JobExecutionException(QuartzMessages.missingJobDetail("jobConfig").getMessage());
        }
        try {
            TransactionTemplate tt;
            this.logger.debug((Object)("Attempting to receive event on: " + jobConfig.getEndpointRef()));
            final AtomicBoolean pollGlobalEndpoint = new AtomicBoolean(false);
            InboundEndpoint endpoint = (InboundEndpoint)this.muleContext.getRegistry().lookupObject(jobConfig.getEndpointRef() + ".quartz-job");
            if (endpoint == null) {
                EndpointBuilder epBuilder = this.muleContext.getRegistry().lookupEndpointBuilder(jobConfig.getEndpointRef());
                pollGlobalEndpoint.set(epBuilder != null);
                if (pollGlobalEndpoint.get()) {
                    endpoint = epBuilder.buildInboundEndpoint();
                    this.muleContext.getRegistry().registerObject(jobConfig.getEndpointRef() + ".quartz-job", (Object)endpoint);
                    tt = new TransactionTemplate(endpoint.getTransactionConfig(), this.muleContext);
                } else {
                    tt = new TransactionTemplate((TransactionConfig)new MuleTransactionConfig(), this.muleContext);
                }
            } else {
                tt = new TransactionTemplate(endpoint.getTransactionConfig(), this.muleContext);
            }
            final InboundEndpoint finalEndpoint = endpoint;
            TransactionCallback<Void> cb = new TransactionCallback<Void>(){

                public Void doInTransaction() throws Exception {
                    Transaction tx = TransactionCoordination.getInstance().getTransaction();
                    if (tx != null) {
                        tx.begin();
                    }
                    MuleMessage result = null;
                    if (pollGlobalEndpoint.get()) {
                        result = finalEndpoint.getConnector().request(finalEndpoint, (long)jobConfig.getTimeout());
                    } else {
                        MuleClient client = new MuleClient(connector.getMuleContext());
                        result = client.request(jobConfig.getEndpointRef(), (long)jobConfig.getTimeout());
                    }
                    if (result != null) {
                        if (EndpointPollingJob.this.logger.isDebugEnabled()) {
                            EndpointPollingJob.this.logger.debug((Object)("Received event on: " + jobConfig.getEndpointRef()));
                        }
                        if (pollGlobalEndpoint.get()) {
                            result.applyTransformers(null, finalEndpoint.getTransformers());
                        }
                        result = (MuleMessage)((ThreadSafeAccess)result).newThreadCopy();
                        result.addProperties((Map)jobDataMap, PropertyScope.INVOCATION);
                        receiver.routeMessage(result);
                    }
                    return null;
                }
            };
            tt.execute((TransactionCallback)cb);
        }
        catch (RuntimeException rex) {
            throw rex;
        }
        catch (Exception e) {
            throw new JobExecutionException((Throwable)e);
        }
    }
}

