/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.provider.jcs;

import java.beans.PropertyEditor;
import java.io.Serializable;
import org.apache.jcs.engine.CacheElement;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.behavior.IElementAttributes;
import org.apache.jcs.engine.control.CompositeCache;
import org.apache.jcs.engine.control.CompositeCacheManager;
import org.apache.jcs.engine.control.group.GroupAttrName;
import org.apache.jcs.engine.control.group.GroupId;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springmodules.cache.CacheException;
import org.springmodules.cache.CachingModel;
import org.springmodules.cache.FatalCacheException;
import org.springmodules.cache.FlushingModel;
import org.springmodules.cache.provider.AbstractCacheProviderFacade;
import org.springmodules.cache.provider.CacheAccessException;
import org.springmodules.cache.provider.CacheModelValidator;
import org.springmodules.cache.provider.CacheNotFoundException;
import org.springmodules.cache.provider.ReflectionCacheModelEditor;
import org.springmodules.cache.provider.jcs.JcsCachingModel;
import org.springmodules.cache.provider.jcs.JcsFlushingModel;
import org.springmodules.cache.provider.jcs.JcsFlushingModelEditor;
import org.springmodules.cache.provider.jcs.JcsModelValidator;

public final class JcsFacade
extends AbstractCacheProviderFacade {
    private CompositeCacheManager cacheManager;
    private CacheModelValidator cacheModelValidator = new JcsModelValidator();
    static /* synthetic */ Class class$org$springmodules$cache$provider$jcs$JcsCachingModel;

    public CacheModelValidator modelValidator() {
        return this.cacheModelValidator;
    }

    public PropertyEditor getCachingModelEditor() {
        ReflectionCacheModelEditor editor = new ReflectionCacheModelEditor();
        editor.setCacheModelClass(class$org$springmodules$cache$provider$jcs$JcsCachingModel == null ? (class$org$springmodules$cache$provider$jcs$JcsCachingModel = JcsFacade.class$("org.springmodules.cache.provider.jcs.JcsCachingModel")) : class$org$springmodules$cache$provider$jcs$JcsCachingModel);
        return editor;
    }

    public PropertyEditor getFlushingModelEditor() {
        return new JcsFlushingModelEditor();
    }

    public void setCacheManager(CompositeCacheManager newCacheManager) {
        this.cacheManager = newCacheManager;
    }

    protected CompositeCache getCache(String name) {
        CompositeCache cache = this.cacheManager.getCache(name);
        if (cache == null) {
            throw new CacheNotFoundException(name);
        }
        return cache;
    }

    protected Serializable getKey(Serializable key, JcsCachingModel model) {
        Serializable newKey = key;
        String group = model.getGroup();
        if (StringUtils.hasText((String)group)) {
            GroupId groupId = new GroupId(model.getCacheName(), group);
            newKey = new GroupAttrName(groupId, (Object)key);
        }
        return newKey;
    }

    protected boolean isSerializableCacheElementRequired() {
        return true;
    }

    protected void onFlushCache(FlushingModel model) throws CacheException {
        JcsFlushingModel flushingModel = (JcsFlushingModel)model;
        JcsFlushingModel.CacheStruct[] cacheStructs = flushingModel.getCacheStructs();
        if (cacheStructs == null) {
            return;
        }
        try {
            int structCount = cacheStructs.length;
            for (int i = 0; i < structCount; ++i) {
                JcsFlushingModel.CacheStruct cacheStruct = cacheStructs[i];
                if (cacheStruct == null) continue;
                String cacheName = cacheStruct.getCacheName();
                Object[] groups = cacheStruct.getGroups();
                CompositeCache cache = this.getCache(cacheName);
                if (!ObjectUtils.isEmpty((Object[])groups)) {
                    int groupCount = groups.length;
                    for (int j = 0; j < groupCount; ++j) {
                        GroupId groupId = new GroupId(cacheName, (String)groups[j]);
                        cache.remove((Serializable)groupId);
                    }
                    continue;
                }
                cache.removeAll();
            }
        }
        catch (Exception exception) {
            throw new CacheAccessException(exception);
        }
    }

    protected Object onGetFromCache(Serializable key, CachingModel model) throws CacheException {
        JcsCachingModel cachingModel = (JcsCachingModel)model;
        String cacheName = cachingModel.getCacheName();
        CompositeCache cache = this.getCache(cacheName);
        Serializable newKey = this.getKey(key, cachingModel);
        Serializable cachedObject = null;
        try {
            ICacheElement cacheElement = cache.get(newKey);
            if (cacheElement != null) {
                cachedObject = cacheElement.getVal();
            }
        }
        catch (Exception exception) {
            throw new CacheAccessException(exception);
        }
        return cachedObject;
    }

    protected void onPutInCache(Serializable key, CachingModel model, Object obj) throws CacheException {
        JcsCachingModel cachingModel = (JcsCachingModel)model;
        String cacheName = cachingModel.getCacheName();
        CompositeCache cache = this.getCache(cacheName);
        Serializable newKey = this.getKey(key, cachingModel);
        CacheElement newCacheElement = new CacheElement(cache.getCacheName(), newKey, obj);
        IElementAttributes elementAttributes = cache.getElementAttributes().copy();
        newCacheElement.setElementAttributes(elementAttributes);
        try {
            cache.update((ICacheElement)newCacheElement);
        }
        catch (Exception exception) {
            throw new CacheAccessException(exception);
        }
    }

    protected void onRemoveFromCache(Serializable key, CachingModel model) throws CacheException {
        JcsCachingModel cachingModel = (JcsCachingModel)model;
        String cacheName = cachingModel.getCacheName();
        CompositeCache cache = this.getCache(cacheName);
        Serializable newKey = this.getKey(key, cachingModel);
        try {
            cache.remove(newKey);
        }
        catch (Exception exception) {
            throw new CacheAccessException(exception);
        }
    }

    protected void validateCacheManager() throws FatalCacheException {
        this.assertCacheManagerIsNotNull(this.cacheManager);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

