/*
 * $Id: DatabindingTestCase.java 22450 2011-07-19 08:20:41Z dirk.olmes $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.module.cxf;

import org.mule.api.MuleMessage;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.module.client.MuleClient;
import org.mule.tck.junit4.FunctionalTestCase;

import org.junit.Test;

import static org.junit.Assert.assertNotNull;

public class DatabindingTestCase extends FunctionalTestCase
{

    @Override
    protected String getConfigResources()
    {
        return "databinding-conf.xml";
    }

    @Test
    public void testEchoWsdl() throws Exception
    {
        MuleClient client = new MuleClient(muleContext);
        MuleMessage result = client.request(((InboundEndpoint) client.getMuleContext().getRegistry()
                        .lookupObject("httpInbound")).getAddress() + "?wsdl", 5000);
        assertNotNull(result.getPayload());
    }

}
