/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.commons.schema.utils;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionFactory {
    private static final String PROTECT_READ_ONLY_COLLECTIONS_PROP = "org.apache.ws.commons.schema.protectReadOnlyCollections";
    private static final ThreadLocal<Boolean> PROTECT_READ_ONLY_COLLECTIONS = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            try {
                return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                    @Override
                    public Boolean run() {
                        return Boolean.parseBoolean(System.getProperty(CollectionFactory.PROTECT_READ_ONLY_COLLECTIONS_PROP));
                    }
                });
            }
            catch (SecurityException ex) {
                return false;
            }
        }
    };

    private CollectionFactory() {
    }

    public static <T> List<T> getList(Class<T> type) {
        return Collections.synchronizedList(new ArrayList());
    }

    public static <T> Set<T> getSet(Class<T> type) {
        return Collections.synchronizedSet(new HashSet());
    }

    public static <T> List<T> getProtectedList(List<T> list) {
        if (PROTECT_READ_ONLY_COLLECTIONS.get().booleanValue()) {
            return Collections.unmodifiableList(list);
        }
        return list;
    }

    public static <K, V> Map<K, V> getProtectedMap(Map<K, V> map) {
        if (PROTECT_READ_ONLY_COLLECTIONS.get().booleanValue()) {
            return Collections.unmodifiableMap(map);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void withSchemaModifiable(Runnable action) {
        Boolean saved = PROTECT_READ_ONLY_COLLECTIONS.get();
        try {
            PROTECT_READ_ONLY_COLLECTIONS.set(Boolean.FALSE);
            action.run();
        }
        finally {
            PROTECT_READ_ONLY_COLLECTIONS.set(saved);
        }
    }
}

