/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class QueryLoader {
    private static final QueryLoader instance = new QueryLoader();
    private final Map queries = new HashMap();

    public static QueryLoader instance() {
        return instance;
    }

    protected QueryLoader() {
    }

    public synchronized Map load(String path) throws IOException {
        Map queryMap = (Map)this.queries.get(path);
        if (queryMap == null) {
            queryMap = this.loadQueries(path);
            this.queries.put(path, queryMap);
        }
        return queryMap;
    }

    protected Map loadQueries(String path) throws IOException {
        InputStream in = this.getClass().getResourceAsStream(path);
        if (in == null) {
            throw new IllegalArgumentException(path + " not found.");
        }
        Properties props = new Properties();
        props.load(in);
        return new HashMap<Object, Object>(props);
    }

    public synchronized void unload(String path) {
        this.queries.remove(path);
    }
}

