/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.map.LRUMap;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.api.expression.ExpressionEvaluator;

public class RegexExpressionEvaluator
implements ExpressionEvaluator {
    private static final String NAME = "regex";
    private static final int SINGLE_CAPTURE_GROUP = 1;
    private static final int NO_CAPTURE_GROUP = 0;
    private Map<String, Pattern> patterns = Collections.synchronizedMap(new LRUMap(256));

    @Override
    public Object evaluate(String expression, MuleMessage message) {
        Matcher matcher = this.createMatcher(expression, message);
        String[] result = null;
        if (matcher.matches()) {
            if (matcher.groupCount() == 0 || matcher.groupCount() == 1) {
                result = matcher.group(matcher.groupCount());
            } else {
                String[] matchedValues = new String[matcher.groupCount()];
                for (int i = 1; i <= matcher.groupCount(); ++i) {
                    matchedValues[i - 1] = matcher.group(i);
                }
                result = matchedValues;
            }
        }
        return result;
    }

    private Matcher createMatcher(String expression, MuleMessage message) {
        String payload;
        Pattern pattern = this.patterns.get(expression);
        if (pattern == null) {
            pattern = Pattern.compile(expression);
            this.patterns.put(expression, pattern);
        }
        try {
            payload = message.getPayloadAsString();
        }
        catch (Exception e) {
            throw new MuleRuntimeException(e);
        }
        return pattern.matcher(payload);
    }

    @Override
    public void setName(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return NAME;
    }
}

