/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.context.MuleContextAware;
import org.mule.api.expression.ExpressionEvaluator;
import org.mule.api.expression.ExpressionRuntimeException;
import org.mule.api.registry.RegistrationException;
import org.mule.config.i18n.CoreMessages;
import org.mule.endpoint.AbstractEndpointBuilder;
import org.mule.util.ClassUtils;

public class RegistryExpressionEvaluator
implements ExpressionEvaluator,
MuleContextAware {
    protected final transient Log logger = LogFactory.getLog(RegistryExpressionEvaluator.class);
    public static final String NAME = "registry";
    private MuleContext muleContext;

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    @Override
    public Object evaluate(String expression, MuleMessage message) {
        Object o;
        String name;
        if (expression.startsWith("type:")) {
            Class clazz;
            String c = expression.substring(5);
            try {
                clazz = ClassUtils.loadClass(c, this.getClass());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Class not on the classpath: " + c);
            }
            try {
                return this.muleContext.getRegistry().lookupObject(clazz);
            }
            catch (RegistrationException e) {
                return null;
            }
        }
        int i = expression.indexOf(".");
        String property = null;
        boolean propertyRequired = true;
        boolean objectRequired = true;
        if (i > 0) {
            name = expression.substring(0, i);
            property = expression.substring(i + 1);
            if (property.endsWith("*")) {
                propertyRequired = false;
                property = property.substring(property.length() - 1);
            }
        } else {
            name = expression;
        }
        if (name.endsWith("*")) {
            objectRequired = false;
            name = name.substring(name.length() - 1);
        }
        if ((o = this.muleContext.getRegistry().lookupObject(name)) == null && objectRequired) {
            throw new ExpressionRuntimeException(CoreMessages.expressionEvaluatorReturnedNull(NAME, expression));
        }
        if (o == null || property == null) {
            return o;
        }
        if (this.muleContext.getExpressionManager().isEvaluatorRegistered("bean")) {
            Object p;
            if (o instanceof AbstractEndpointBuilder) {
                property = "endpointBuilder.endpoint." + property;
            }
            if ((p = this.muleContext.getExpressionManager().evaluate("#[bean:" + property + "]", new DefaultMuleMessage(o, this.muleContext))) == null && propertyRequired) {
                throw new ExpressionRuntimeException(CoreMessages.expressionEvaluatorReturnedNull(NAME, name + "." + property));
            }
            return p;
        }
        throw new ExpressionRuntimeException(CoreMessages.expressionEvaluatorNotRegistered("bean"));
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void setName(String name) {
        throw new UnsupportedOperationException();
    }
}

