/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.polling;

import java.util.Map;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transaction.TransactionCallback;
import org.mule.api.transport.Connector;
import org.mule.config.i18n.CoreMessages;
import org.mule.transaction.TransactionTemplate;
import org.mule.transaction.TransactionTemplateFactory;
import org.mule.transport.AbstractPollingMessageReceiver;
import org.mule.transport.NullPayload;

public class MessageProcessorPollingMessageReceiver
extends AbstractPollingMessageReceiver {
    public static final String SOURCE_MESSAGE_PROCESSOR_PROPERTY_NAME = "MULE_ENDPOINT__sourceMessageProcessor";
    protected MessageProcessor sourceMessageProcessor;

    public MessageProcessorPollingMessageReceiver(Connector connector, FlowConstruct flowConstruct, InboundEndpoint endpoint) throws CreateException {
        super(connector, flowConstruct, endpoint);
    }

    @Override
    protected void doInitialise() throws InitialisationException {
        super.doInitialise();
        this.sourceMessageProcessor = (MessageProcessor)this.endpoint.getProperty(SOURCE_MESSAGE_PROCESSOR_PROPERTY_NAME);
        if (this.sourceMessageProcessor instanceof OutboundEndpoint && !((OutboundEndpoint)this.sourceMessageProcessor).getExchangePattern().hasResponse()) {
            throw new InitialisationException(CoreMessages.createStaticMessage(String.format("The endpoint %s does not return responses and therefore can't be used for polling.", this.sourceMessageProcessor)), (Initialisable)this);
        }
        Long tempPolling = (Long)this.endpoint.getProperties().get("pollingFrequency");
        if (tempPolling != null) {
            this.setFrequency(tempPolling);
        }
    }

    @Override
    public void poll() throws Exception {
        TransactionTemplate mainTransactionTemplate = TransactionTemplateFactory.createMainTransactionTemplate(this.endpoint.getTransactionConfig(), this.connector.getMuleContext());
        try {
            mainTransactionTemplate.execute(new TransactionCallback<Void>(){

                @Override
                public Void doInTransaction() throws Exception {
                    DefaultMuleEvent event;
                    MuleEvent sourceEvent;
                    DefaultMuleMessage request = new DefaultMuleMessage((Object)"", (Map<String, Object>)null, MessageProcessorPollingMessageReceiver.this.connector.getMuleContext());
                    ImmutableEndpoint ep = MessageProcessorPollingMessageReceiver.this.endpoint;
                    if (MessageProcessorPollingMessageReceiver.this.sourceMessageProcessor instanceof ImmutableEndpoint) {
                        ep = (ImmutableEndpoint)((Object)MessageProcessorPollingMessageReceiver.this.sourceMessageProcessor);
                    }
                    if (MessageProcessorPollingMessageReceiver.this.isNewMessage(sourceEvent = MessageProcessorPollingMessageReceiver.this.sourceMessageProcessor.process(event = new DefaultMuleEvent((MuleMessage)request, ep.getExchangePattern(), MessageProcessorPollingMessageReceiver.this.flowConstruct)))) {
                        MessageProcessorPollingMessageReceiver.this.routeMessage(sourceEvent.getMessage());
                    } else {
                        MessageProcessorPollingMessageReceiver.this.logger.info((Object)String.format("Polling of '%s' returned null, the flow will not be invoked.", MessageProcessorPollingMessageReceiver.this.sourceMessageProcessor));
                    }
                    return null;
                }
            });
        }
        catch (MessagingException e) {
        }
        catch (Exception e) {
            this.connector.getMuleContext().getExceptionListener().handleException(e);
        }
    }

    @Override
    protected boolean pollOnPrimaryInstanceOnly() {
        return true;
    }

    protected boolean isNewMessage(MuleEvent sourceEvent) {
        if (sourceEvent != null && sourceEvent.getMessage() != null) {
            MuleMessage message = sourceEvent.getMessage();
            return !message.getPayload().equals(NullPayload.getInstance());
        }
        return false;
    }
}

