/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mule.api.MuleContext;
import org.mule.api.registry.Registry;
import org.mule.registry.RegistryMap;
import org.mule.util.IOUtils;
import org.mule.util.TemplateParser;

public class JarResourceServlet
extends HttpServlet {
    public static final String DEFAULT_PATH_SPEC = "/mule-resource/*";
    public static final String DEFAULT_BASE_PATH = "";
    public static final String DEFAULT_MIME_TYPE = "application/octet-stream";
    private String basepath = "";
    private String[] templateExtensions = new String[]{"htm", "html", "xml", "json"};
    private TemplateParser templateParser = TemplateParser.createAntStyleParser();
    private MuleContext muleContext;
    private Map<?, ?> properties;

    public void init() throws ServletException {
        this.muleContext = (MuleContext)this.getServletContext().getAttribute("mule.context");
        if (this.muleContext == null) {
            throw new ServletException("Property mule.context not set on ServletContext");
        }
        this.properties = new RegistryMap((Registry)this.muleContext.getRegistry());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String file = this.getFile(request);
        InputStream in = IOUtils.getResourceAsStream((String)file, ((Object)((Object)this)).getClass(), (boolean)false, (boolean)false);
        if (in == null) {
            response.setStatus(404);
            response.getWriter().write("Unable to find file: " + request.getPathInfo());
            return;
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtils.copyLarge((InputStream)in, (OutputStream)baos);
            byte[] buffer = baos.toByteArray();
            String mimetype = this.determineMimeType(file);
            buffer = this.expandTemplates(buffer, mimetype);
            response.setContentType(mimetype);
            response.setContentLength(buffer.length);
            if (mimetype.equals(DEFAULT_MIME_TYPE)) {
                response.setHeader("Content-Disposition", "attachment; filename=\"" + request.getPathInfo() + "\"");
            }
            response.getOutputStream().write(buffer);
        }
        finally {
            in.close();
            response.getOutputStream().flush();
        }
    }

    protected String getFile(HttpServletRequest request) {
        String file = this.getBasepath() + request.getPathInfo();
        if (file.startsWith("/")) {
            file = file.substring(1);
        }
        return file;
    }

    protected String determineMimeType(String file) {
        String temp;
        String mimetype = DEFAULT_MIME_TYPE;
        if (this.getServletContext() != null && (temp = this.getServletContext().getMimeType(file)) != null) {
            mimetype = temp;
        }
        return mimetype;
    }

    protected byte[] expandTemplates(byte[] buffer, String mimetype) {
        for (String extension : this.templateExtensions) {
            if (!mimetype.endsWith(extension)) continue;
            return this.templateParser.parse(this.properties, new String(buffer)).getBytes();
        }
        return buffer;
    }

    public String getBasepath() {
        return this.basepath;
    }

    public void setBasepath(String basepath) {
        this.basepath = basepath;
    }
}

