/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.binding.decoding;

import java.util.List;
import javax.xml.namespace.QName;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.saml2.binding.decoding.BaseSAML2MessageDecoder;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.message.decoder.MessageDecodingException;
import org.opensaml.ws.soap.soap11.Envelope;
import org.opensaml.ws.soap.soap11.Header;
import org.opensaml.ws.transport.http.HTTPInTransport;
import org.opensaml.xml.AttributeExtensibleXMLObject;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.LazyList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPSOAP11Decoder
extends BaseSAML2MessageDecoder {
    private final Logger log = LoggerFactory.getLogger(HTTPSOAP11Decoder.class);
    private List<QName> understoodHeaders;
    private final QName soapMustUnderstand = new QName("http://schemas.xmlsoap.org/soap/envelope/", "mustUnderstand");

    public HTTPSOAP11Decoder() {
        this.understoodHeaders = new LazyList();
    }

    public HTTPSOAP11Decoder(ParserPool pool) {
        super(pool);
        this.understoodHeaders = new LazyList();
    }

    @Override
    public String getBindingURI() {
        return "urn:oasis:names:tc:SAML:2.0:bindings:SOAP";
    }

    @Override
    protected boolean isIntendedDestinationEndpointURIRequired(SAMLMessageContext samlMsgCtx) {
        return false;
    }

    public List<QName> getUnderstoodHeaders() {
        return this.understoodHeaders;
    }

    public void setUnderstoodHeaders(List<QName> headerNames) {
        this.understoodHeaders.clear();
        if (headerNames != null) {
            this.understoodHeaders.addAll(headerNames);
        }
    }

    protected void doDecode(MessageContext messageContext) throws MessageDecodingException {
        List soapBodyChildren;
        if (!(messageContext instanceof SAMLMessageContext)) {
            this.log.error("Invalid message context type, this decoder only support SAMLMessageContext");
            throw new MessageDecodingException("Invalid message context type, this decoder only support SAMLMessageContext");
        }
        if (!(messageContext.getInboundMessageTransport() instanceof HTTPInTransport)) {
            this.log.error("Invalid inbound message transport type, this decoder only support HTTPInTransport");
            throw new MessageDecodingException("Invalid inbound message transport type, this decoder only support HTTPInTransport");
        }
        SAMLMessageContext samlMsgCtx = (SAMLMessageContext)messageContext;
        HTTPInTransport inTransport = (HTTPInTransport)samlMsgCtx.getInboundMessageTransport();
        if (!inTransport.getHTTPMethod().equalsIgnoreCase("POST")) {
            throw new MessageDecodingException("This message deocoder only supports the HTTP POST method");
        }
        this.log.debug("Unmarshalling SOAP message");
        Envelope soapMessage = (Envelope)this.unmarshallMessage(inTransport.getIncomingStream());
        samlMsgCtx.setInboundMessage((XMLObject)soapMessage);
        Header messageHeader = soapMessage.getHeader();
        if (messageHeader != null) {
            this.checkUnderstoodSOAPHeaders(soapMessage.getHeader().getUnknownXMLObjects());
        }
        if ((soapBodyChildren = soapMessage.getBody().getUnknownXMLObjects()).size() < 1 || soapBodyChildren.size() > 1) {
            this.log.error("Unexpected number of children in the SOAP body, " + soapBodyChildren.size() + ".  Unable to extract SAML message");
            throw new MessageDecodingException("Unexpected number of children in the SOAP body, unable to extract SAML message");
        }
        XMLObject incommingMessage = (XMLObject)soapBodyChildren.get(0);
        if (!(incommingMessage instanceof SAMLObject)) {
            this.log.error("Unexpected SOAP body content.  Expected a SAML request but recieved {}", (Object)incommingMessage.getElementQName());
            throw new MessageDecodingException("Unexpected SOAP body content.  Expected a SAML request but recieved " + incommingMessage.getElementQName());
        }
        SAMLObject samlMessage = (SAMLObject)incommingMessage;
        this.log.debug("Decoded SOAP messaged which included SAML message of type {}", (Object)samlMessage.getElementQName());
        samlMsgCtx.setInboundSAMLMessage(samlMessage);
        this.populateMessageContext(samlMsgCtx);
    }

    protected void checkUnderstoodSOAPHeaders(List<XMLObject> headers) throws MessageDecodingException {
        if (headers == null || headers.isEmpty()) {
            return;
        }
        for (XMLObject header : headers) {
            AttributeExtensibleXMLObject attribExtensObject;
            if (!(header instanceof AttributeExtensibleXMLObject) || !DatatypeHelper.safeEquals((Object)"1", (Object)(attribExtensObject = (AttributeExtensibleXMLObject)header).getUnknownAttributes().get((Object)this.soapMustUnderstand)) || this.understoodHeaders.contains(header.getElementQName())) continue;
            throw new MessageDecodingException("SOAP decoder encountered a  header, " + header.getElementQName() + ", that requires undestanding however this decoder does not understand that header");
        }
    }
}

