/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.binding.encoding;

import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.saml2.binding.encoding.BaseSAML2MessageEncoder;
import org.opensaml.saml2.core.RequestAbstractType;
import org.opensaml.saml2.core.StatusResponseType;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.opensaml.ws.transport.http.HTTPOutTransport;
import org.opensaml.ws.transport.http.HTTPTransportUtils;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.util.Base64;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class HTTPPostEncoder
extends BaseSAML2MessageEncoder {
    private final Logger log = LoggerFactory.getLogger(HTTPPostEncoder.class);
    private VelocityEngine velocityEngine;
    private String velocityTemplateId;

    public HTTPPostEncoder(VelocityEngine engine, String templateId) {
        this.velocityEngine = engine;
        this.velocityTemplateId = templateId;
    }

    public String getBindingURI() {
        return "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST";
    }

    public boolean providesMessageConfidentiality(MessageContext messageContext) throws MessageEncodingException {
        return false;
    }

    public boolean providesMessageIntegrity(MessageContext messageContext) throws MessageEncodingException {
        return false;
    }

    protected void doEncode(MessageContext messageContext) throws MessageEncodingException {
        if (!(messageContext instanceof SAMLMessageContext)) {
            this.log.error("Invalid message context type, this encoder only support SAMLMessageContext");
            throw new MessageEncodingException("Invalid message context type, this encoder only support SAMLMessageContext");
        }
        if (!(messageContext.getOutboundMessageTransport() instanceof HTTPOutTransport)) {
            this.log.error("Invalid outbound message transport type, this encoder only support HTTPOutTransport");
            throw new MessageEncodingException("Invalid outbound message transport type, this encoder only support HTTPOutTransport");
        }
        SAMLMessageContext samlMsgCtx = (SAMLMessageContext)messageContext;
        Object outboundMessage = samlMsgCtx.getOutboundSAMLMessage();
        if (outboundMessage == null) {
            throw new MessageEncodingException("No outbound SAML message contained in message context");
        }
        String endpointURL = this.getEndpointURL(samlMsgCtx).buildURL();
        if (samlMsgCtx.getOutboundSAMLMessage() instanceof StatusResponseType) {
            ((StatusResponseType)samlMsgCtx.getOutboundSAMLMessage()).setDestination(endpointURL);
        }
        this.signMessage(samlMsgCtx);
        samlMsgCtx.setOutboundMessage((XMLObject)outboundMessage);
        this.postEncode(samlMsgCtx, endpointURL);
    }

    protected void postEncode(SAMLMessageContext messageContext, String endpointURL) throws MessageEncodingException {
        this.log.debug("Invoking Velocity template to create POST body");
        try {
            VelocityContext context = new VelocityContext();
            this.populateVelocityContext(context, messageContext, endpointURL);
            HTTPOutTransport outTransport = (HTTPOutTransport)messageContext.getOutboundMessageTransport();
            HTTPTransportUtils.addNoCacheHeaders((HTTPOutTransport)outTransport);
            HTTPTransportUtils.setUTF8Encoding((HTTPOutTransport)outTransport);
            HTTPTransportUtils.setContentType((HTTPOutTransport)outTransport, (String)"text/html");
            OutputStreamWriter out = new OutputStreamWriter(outTransport.getOutgoingStream(), "UTF-8");
            this.velocityEngine.mergeTemplate(this.velocityTemplateId, "UTF-8", (Context)context, (Writer)out);
            ((Writer)out).flush();
        }
        catch (Exception e) {
            this.log.error("Error invoking Velocity template", (Throwable)e);
            throw new MessageEncodingException("Error creating output document", e);
        }
    }

    protected void populateVelocityContext(VelocityContext velocityContext, SAMLMessageContext messageContext, String endpointURL) throws MessageEncodingException {
        block6: {
            this.log.debug("Encoding action url of: {}", (Object)endpointURL);
            velocityContext.put("action", (Object)endpointURL);
            this.log.debug("Marshalling and Base64 encoding SAML message");
            if (messageContext.getOutboundSAMLMessage().getDOM() == null) {
                this.marshallMessage((XMLObject)messageContext.getOutboundSAMLMessage());
            }
            try {
                String messageXML = XMLHelper.nodeToString((Node)messageContext.getOutboundSAMLMessage().getDOM());
                String encodedMessage = Base64.encodeBytes((byte[])messageXML.getBytes("UTF-8"), (int)8);
                if (messageContext.getOutboundSAMLMessage() instanceof RequestAbstractType) {
                    velocityContext.put("SAMLRequest", (Object)encodedMessage);
                    break block6;
                }
                if (messageContext.getOutboundSAMLMessage() instanceof StatusResponseType) {
                    velocityContext.put("SAMLResponse", (Object)encodedMessage);
                    break block6;
                }
                throw new MessageEncodingException("SAML message is neither a SAML RequestAbstractType or StatusResponseType");
            }
            catch (UnsupportedEncodingException e) {
                this.log.error("UTF-8 encoding is not supported, this VM is not Java compliant.");
                throw new MessageEncodingException("Unable to encode message, UTF-8 encoding is not supported");
            }
        }
        String relayState = messageContext.getRelayState();
        if (this.checkRelayState(relayState)) {
            this.log.debug("Encoding relay state of: {}", (Object)relayState);
            velocityContext.put("RelayState", (Object)relayState);
        }
    }
}

