/*
 * Decompiled with CFR 0.152.
 */
package org.ibeans.impl;

import java.lang.reflect.Method;
import java.util.HashMap;
import javax.activation.DataHandler;
import org.ibeans.annotation.Invoke;
import org.ibeans.api.ClientAnnotationHandler;
import org.ibeans.api.IBeansException;
import org.ibeans.api.InvocationContext;
import org.ibeans.api.Request;
import org.ibeans.api.Response;
import org.ibeans.spi.IBeansPlugin;

public class InvokeAnnotationHandler
implements ClientAnnotationHandler {
    private IBeansPlugin plugin;

    public InvokeAnnotationHandler(IBeansPlugin plugin) {
        this.plugin = plugin;
    }

    public Response invoke(InvocationContext ctx) throws Exception {
        Invoke invokeInfo = ctx.getMethod().getAnnotation(Invoke.class);
        Object target = ctx.getIBeanConfig().getPropertyParams().get(invokeInfo.object());
        if (target == null) {
            throw new IllegalArgumentException("No object called '" + invokeInfo.object() + "' set on the invocationContext properties");
        }
        Object[] args = ctx.getIBeanConfig().getPayloadParams().values().toArray();
        Class[] paramTypes = ctx.getParamTypes();
        if (args.length > 0 && paramTypes == null) {
            paramTypes = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                paramTypes[i] = args[i].getClass();
            }
        }
        Method method = target.getClass().getMethod(invokeInfo.method(), paramTypes);
        Object result = method.invoke(target, args);
        return this.createResponse(result, ctx.getRequest());
    }

    protected Response createResponse(Object payload, Request request) throws IBeansException {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        for (String s : request.getHeaderNames()) {
            headers.put(s, request.getHeader(s));
        }
        HashMap<String, DataHandler> attachments = new HashMap<String, DataHandler>();
        for (String s : request.getAttachmentNames()) {
            attachments.put(s, request.getAttachment(s));
        }
        return this.plugin.createResponse(payload, headers, attachments);
    }

    public String getScheme(Method method) {
        return "invoke";
    }
}

