/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.staxon;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;

public abstract class AbstractXMLOutputFactory
extends XMLOutputFactory {
    @Override
    public XMLStreamWriter createXMLStreamWriter(OutputStream stream, String encoding) throws XMLStreamException {
        try {
            return this.createXMLStreamWriter(new OutputStreamWriter(stream, encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public XMLStreamWriter createXMLStreamWriter(Result result) throws XMLStreamException {
        if (result instanceof StreamResult) {
            StreamResult streamResult = (StreamResult)result;
            OutputStream output = streamResult.getOutputStream();
            if (output != null) {
                return this.createXMLStreamWriter(output);
            }
            Writer writer = streamResult.getWriter();
            if (writer != null) {
                return this.createXMLStreamWriter(writer);
            }
            if (result.getSystemId() != null) {
                throw new XMLStreamException("Cannot open system id as URL for writing: " + result.getSystemId());
            }
            throw new XMLStreamException("Invalid stream result: none of output, writer, systemId set");
        }
        throw new XMLStreamException("Unsupported result type: " + result.getClass());
    }

    @Override
    public XMLEventWriter createXMLEventWriter(Result result) throws XMLStreamException {
        return this.createXMLEventWriter(this.createXMLStreamWriter(result));
    }

    @Override
    public XMLEventWriter createXMLEventWriter(OutputStream stream) throws XMLStreamException {
        return this.createXMLEventWriter(this.createXMLStreamWriter(stream));
    }

    @Override
    public XMLEventWriter createXMLEventWriter(OutputStream stream, String encoding) throws XMLStreamException {
        return this.createXMLEventWriter(this.createXMLStreamWriter(stream, encoding));
    }

    @Override
    public XMLEventWriter createXMLEventWriter(Writer stream) throws XMLStreamException {
        return this.createXMLEventWriter(this.createXMLStreamWriter(stream));
    }

    public abstract XMLEventWriter createXMLEventWriter(XMLStreamWriter var1) throws XMLStreamException;
}

