/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.staxon.event;

import de.odysseus.staxon.event.SimpleXMLEventAllocator;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.XMLEvent;
import javax.xml.stream.util.XMLEventAllocator;

public class SimpleXMLEventReader
implements XMLEventReader {
    private final XMLEventAllocator allocator;
    private final XMLStreamReader delegate;
    private int currentEventType = -1;
    private XMLEvent peekedEvent = null;

    public SimpleXMLEventReader(XMLStreamReader delegate) {
        this(delegate, new SimpleXMLEventAllocator());
    }

    public SimpleXMLEventReader(XMLStreamReader delegate, XMLEventAllocator allocator) {
        this.delegate = delegate;
        this.allocator = allocator;
    }

    protected XMLEvent allocate() throws XMLStreamException {
        return this.allocator.allocate(this.delegate);
    }

    @Override
    public void close() throws XMLStreamException {
        this.delegate.close();
    }

    @Override
    public String getElementText() throws XMLStreamException {
        if (this.currentEventType != 1) {
            throw new XMLStreamException("Expected start element event");
        }
        if (this.peekedEvent == null) {
            String result = this.delegate.getElementText();
            this.currentEventType = this.delegate.getEventType();
            if (this.currentEventType != 2) {
                throw new XMLStreamException("Expected end element event");
            }
            return result;
        }
        this.currentEventType = this.peekedEvent.getEventType();
        assert (this.currentEventType == this.delegate.getEventType());
        this.peekedEvent = null;
        String leadText = null;
        switch (this.currentEventType) {
            case 4: 
            case 9: 
            case 12: {
                leadText = this.delegate.getText();
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 2: {
                return "";
            }
            default: {
                throw new XMLStreamException("Unexpected event type " + this.currentEventType, this.delegate.getLocation());
            }
        }
        StringBuilder builder = null;
        block10: while (true) {
            this.currentEventType = this.delegate.next();
            switch (this.currentEventType) {
                case 4: 
                case 9: 
                case 12: {
                    if (leadText == null) {
                        leadText = this.delegate.getText();
                        continue block10;
                    }
                    if (builder == null) {
                        builder = new StringBuilder(leadText);
                    }
                    builder.append(this.delegate.getText());
                    continue block10;
                }
                case 3: 
                case 5: 
                case 6: {
                    continue block10;
                }
                case 2: {
                    return builder == null ? (leadText == null ? "" : leadText) : builder.toString();
                }
            }
            break;
        }
        throw new XMLStreamException("Unexpected event type " + this.currentEventType, this.delegate.getLocation());
    }

    @Override
    public Object getProperty(String name) {
        return this.delegate.getProperty(name);
    }

    @Override
    public boolean hasNext() {
        try {
            return this.peek() != null;
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Cannot determine next state", e);
        }
    }

    @Override
    public XMLEvent nextEvent() throws XMLStreamException {
        XMLEvent currentEvent = this.peek();
        if (currentEvent == null) {
            throw new XMLStreamException("no more events");
        }
        this.currentEventType = currentEvent.getEventType();
        this.peekedEvent = null;
        return currentEvent;
    }

    @Override
    public Object next() {
        try {
            return this.nextEvent();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public XMLEvent nextTag() throws XMLStreamException {
        if (this.peekedEvent == null) {
            this.currentEventType = this.delegate.nextTag();
            if (this.currentEventType == 1 || this.currentEventType == 2) return this.allocate();
            throw new XMLStreamException("Expected start element event or end element event");
        }
        this.currentEventType = this.peekedEvent.getEventType();
        assert (this.currentEventType == this.delegate.getEventType());
        XMLEvent event = this.peekedEvent;
        this.peekedEvent = null;
        switch (event.getEventType()) {
            case 7: {
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: 
            case 12: {
                if (event.asCharacters().isWhiteSpace()) break;
                throw new XMLStreamException("Encountered non-whitespace text");
            }
            case 1: 
            case 2: {
                return event;
            }
            default: {
                throw new XMLStreamException("Encountered unexpected event: " + event.getEventType());
            }
        }
        block11: while (true) {
            this.currentEventType = this.delegate.next();
            switch (this.currentEventType) {
                case 3: 
                case 5: 
                case 6: {
                    continue block11;
                }
                case 4: 
                case 12: {
                    if (!this.delegate.isWhiteSpace()) throw new XMLStreamException("Encountered non-whitespace text");
                    continue block11;
                }
                case 1: 
                case 2: {
                    return this.allocate();
                }
            }
            break;
        }
        throw new XMLStreamException("Encountered unexpected event: " + this.delegate.getEventType());
    }

    @Override
    public XMLEvent peek() throws XMLStreamException {
        if (this.peekedEvent == null) {
            if (this.currentEventType < 0) {
                this.peekedEvent = this.allocate();
            } else if (this.delegate.hasNext()) {
                this.delegate.next();
                this.peekedEvent = this.allocate();
            }
        }
        return this.peekedEvent;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove events");
    }
}

