/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.staxon.json;

import de.odysseus.staxon.AbstractXMLOutputFactory;
import de.odysseus.staxon.event.SimpleXMLEventWriter;
import de.odysseus.staxon.json.JsonXMLStreamWriter;
import de.odysseus.staxon.json.stream.JsonStreamFactory;
import de.odysseus.staxon.json.stream.JsonStreamTarget;
import de.odysseus.staxon.json.stream.util.AutoArrayTarget;
import de.odysseus.staxon.json.stream.util.RemoveRootTarget;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Arrays;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class JsonXMLOutputFactory
extends AbstractXMLOutputFactory {
    public static final String PROP_AUTO_ARRAY = "JsonXMLOutputFactory.autoArray";
    public static final String PROP_MULTIPLE_PI = "JsonXMLOutputFactory.multiplePI";
    public static final String PROP_VIRTUAL_ROOT = "JsonXMLOutputFactory.virtualRoot";
    public static final String PROP_PRETTY_PRINT = "JsonXMLOutputFactory.prettyPrint";
    private JsonStreamFactory streamFactory = null;
    private boolean multiplePI = true;
    private String virtualRoot = null;
    private boolean autoArray = false;
    private boolean prettyPrint = false;

    public JsonXMLOutputFactory() throws FactoryConfigurationError {
        this(JsonStreamFactory.newFactory());
    }

    public JsonXMLOutputFactory(JsonStreamFactory streamFactory) {
        this.streamFactory = streamFactory;
    }

    private JsonStreamTarget decorate(JsonStreamTarget target) {
        if (this.autoArray) {
            target = new AutoArrayTarget(target);
        }
        if (this.virtualRoot != null) {
            target = new RemoveRootTarget(target, this.virtualRoot);
        }
        return target;
    }

    @Override
    public XMLStreamWriter createXMLStreamWriter(Writer stream) throws XMLStreamException {
        try {
            return new JsonXMLStreamWriter(this.decorate(this.streamFactory.createJsonStreamTarget(stream, this.prettyPrint)), this.multiplePI);
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public XMLStreamWriter createXMLStreamWriter(OutputStream stream) throws XMLStreamException {
        try {
            return new JsonXMLStreamWriter(this.decorate(this.streamFactory.createJsonStreamTarget(stream, this.prettyPrint)), this.multiplePI);
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public XMLEventWriter createXMLEventWriter(XMLStreamWriter writer) throws XMLStreamException {
        return new SimpleXMLEventWriter(writer);
    }

    @Override
    public void setProperty(String name, Object value) throws IllegalArgumentException {
        if ("javax.xml.stream.isRepairingNamespaces".equals(name)) {
            if (!this.getProperty(name).equals(value)) {
                throw new IllegalArgumentException("Cannot change property: " + name);
            }
        } else if (PROP_AUTO_ARRAY.equals(name)) {
            this.autoArray = (Boolean)value;
        } else if (PROP_MULTIPLE_PI.equals(name)) {
            this.multiplePI = (Boolean)value;
        } else if (PROP_VIRTUAL_ROOT.equals(name)) {
            this.virtualRoot = (String)value;
        } else if (PROP_PRETTY_PRINT.equals(name)) {
            this.prettyPrint = (Boolean)value;
        } else {
            throw new IllegalArgumentException("Unsupported property: " + name);
        }
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        if ("javax.xml.stream.isRepairingNamespaces".equals(name)) {
            return Boolean.FALSE;
        }
        if (PROP_AUTO_ARRAY.equals(name)) {
            return this.autoArray;
        }
        if (PROP_MULTIPLE_PI.equals(name)) {
            return this.multiplePI;
        }
        if (PROP_VIRTUAL_ROOT.equals(name)) {
            return this.virtualRoot;
        }
        if (PROP_PRETTY_PRINT.equals(name)) {
            return this.prettyPrint;
        }
        throw new IllegalArgumentException("Unsupported property: " + name);
    }

    @Override
    public boolean isPropertySupported(String name) {
        if ("javax.xml.stream.isRepairingNamespaces".equals(name)) {
            return true;
        }
        return Arrays.asList(PROP_AUTO_ARRAY, PROP_MULTIPLE_PI, PROP_VIRTUAL_ROOT, PROP_PRETTY_PRINT).contains(name);
    }
}

