/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.staxon.json.stream.gson;

import com.google.gson.stream.JsonReader;
import de.odysseus.staxon.json.stream.JsonStreamSource;
import de.odysseus.staxon.json.stream.JsonStreamToken;
import java.io.IOException;

class GsonStreamSource
implements JsonStreamSource {
    private final JsonReader reader;
    private JsonStreamToken peek;

    GsonStreamSource(JsonReader reader) {
        this.reader = reader;
    }

    private void consume(JsonStreamToken token) throws IOException {
        if (this.peek() != token) {
            throw new IllegalStateException("Expected token: " + (Object)((Object)token) + ", but was: " + (Object)((Object)this.peek()));
        }
        this.peek = null;
    }

    private JsonStreamToken read() throws IOException {
        switch (this.reader.peek()) {
            case NAME: {
                return JsonStreamToken.NAME;
            }
            case BOOLEAN: 
            case NULL: 
            case NUMBER: 
            case STRING: {
                return JsonStreamToken.VALUE;
            }
            case BEGIN_OBJECT: {
                return JsonStreamToken.START_OBJECT;
            }
            case END_OBJECT: {
                return JsonStreamToken.END_OBJECT;
            }
            case BEGIN_ARRAY: {
                return JsonStreamToken.START_ARRAY;
            }
            case END_ARRAY: {
                return JsonStreamToken.END_ARRAY;
            }
            case END_DOCUMENT: {
                return JsonStreamToken.NONE;
            }
        }
        throw new IllegalStateException("Unexpected GSON token: " + this.reader.peek());
    }

    @Override
    public void endArray() throws IOException {
        this.consume(JsonStreamToken.END_ARRAY);
        this.reader.endArray();
    }

    @Override
    public void endObject() throws IOException {
        this.consume(JsonStreamToken.END_OBJECT);
        this.reader.endObject();
    }

    @Override
    public String name() throws IOException {
        this.consume(JsonStreamToken.NAME);
        return this.reader.nextName();
    }

    @Override
    public JsonStreamToken peek() throws IOException {
        return this.peek == null ? (this.peek = this.read()) : this.peek;
    }

    @Override
    public void startArray() throws IOException {
        this.consume(JsonStreamToken.START_ARRAY);
        this.reader.beginArray();
    }

    @Override
    public void startObject() throws IOException {
        this.consume(JsonStreamToken.START_OBJECT);
        this.reader.beginObject();
    }

    @Override
    public String value() throws IOException {
        this.consume(JsonStreamToken.VALUE);
        switch (this.reader.peek()) {
            case BOOLEAN: {
                return String.valueOf(this.reader.nextBoolean());
            }
            case NULL: {
                this.reader.nextNull();
                return null;
            }
            case NUMBER: 
            case STRING: {
                return this.reader.nextString();
            }
        }
        throw new IllegalStateException("Not a value token: " + (Object)((Object)this.peek()));
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

