/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.staxon.json.stream.jackson;

import de.odysseus.staxon.json.stream.JsonStreamTarget;
import java.io.IOException;
import org.codehaus.jackson.JsonGenerator;

class JacksonStreamTarget
implements JsonStreamTarget {
    private final JsonGenerator generator;

    JacksonStreamTarget(JsonGenerator generator) {
        this.generator = generator;
    }

    @Override
    public void endArray() throws IOException {
        this.generator.writeEndArray();
    }

    @Override
    public void endObject() throws IOException {
        this.generator.writeEndObject();
    }

    @Override
    public void name(String name) throws IOException {
        this.generator.writeFieldName(name);
    }

    @Override
    public void startArray() throws IOException {
        this.generator.writeStartArray();
    }

    @Override
    public void startObject() throws IOException {
        this.generator.writeStartObject();
    }

    @Override
    public void value(String value) throws IOException {
        if (value == null) {
            this.generator.writeNull();
        } else {
            this.generator.writeString(value);
        }
    }

    @Override
    public void flush() throws IOException {
        this.generator.flush();
    }

    @Override
    public void close() throws IOException {
        this.generator.close();
    }
}

