/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.staxon.json.stream.util;

import de.odysseus.staxon.json.stream.JsonStreamSource;
import de.odysseus.staxon.json.stream.JsonStreamToken;
import java.io.IOException;

public class AddRootSource
implements JsonStreamSource {
    private final JsonStreamSource delegate;
    private final String root;
    private State state = State.START_DOC;
    private int depth = 0;

    public AddRootSource(JsonStreamSource delegate, String root) {
        this.delegate = delegate;
        this.root = root;
    }

    @Override
    public String name() throws IOException {
        if (this.state == State.ROOT_NAME) {
            this.state = State.DELEGATE;
            return this.root;
        }
        return this.delegate.name();
    }

    @Override
    public String value() throws IOException {
        return this.delegate.value();
    }

    @Override
    public void startObject() throws IOException {
        if (this.state == State.START_DOC) {
            this.state = State.ROOT_NAME;
        } else {
            this.delegate.startObject();
        }
        ++this.depth;
    }

    @Override
    public void endObject() throws IOException {
        if (this.depth == 1 && this.state == State.DELEGATE && this.delegate.peek() == JsonStreamToken.NONE) {
            this.state = State.END_DOC;
        }
        if (this.state != State.END_DOC) {
            this.delegate.endObject();
        }
        --this.depth;
    }

    @Override
    public void startArray() throws IOException {
        this.delegate.startArray();
    }

    @Override
    public void endArray() throws IOException {
        this.delegate.endArray();
    }

    @Override
    public JsonStreamToken peek() throws IOException {
        switch (this.state) {
            case START_DOC: {
                return JsonStreamToken.START_OBJECT;
            }
            case ROOT_NAME: {
                return JsonStreamToken.NAME;
            }
            case END_DOC: {
                return JsonStreamToken.END_OBJECT;
            }
        }
        JsonStreamToken result = this.delegate.peek();
        if (this.depth == 1 && result == JsonStreamToken.NONE) {
            result = JsonStreamToken.END_OBJECT;
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    private static enum State {
        START_DOC,
        ROOT_NAME,
        DELEGATE,
        END_DOC;

    }
}

