/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.staxon.json.stream.util;

import de.odysseus.staxon.json.stream.JsonStreamTarget;
import java.io.IOException;

public class RemoveRootTarget
implements JsonStreamTarget {
    private final JsonStreamTarget delegate;
    private final String root;
    private int depth;

    public RemoveRootTarget(JsonStreamTarget delegate, String root) {
        this.delegate = delegate;
        this.root = root;
    }

    @Override
    public void name(String name) throws IOException {
        if (this.depth > 1) {
            this.delegate.name(name);
        } else if (!name.equals(this.root)) {
            throw new IOException("Unexpected root: " + name);
        }
    }

    @Override
    public void value(String value) throws IOException {
        this.delegate.value(value);
    }

    @Override
    public void startObject() throws IOException {
        if (this.depth++ > 0) {
            this.delegate.startObject();
        }
    }

    @Override
    public void endObject() throws IOException {
        if (--this.depth > 0) {
            this.delegate.endObject();
        }
    }

    @Override
    public void startArray() throws IOException {
        this.delegate.startArray();
    }

    @Override
    public void endArray() throws IOException {
        this.delegate.endArray();
    }

    @Override
    public void flush() throws IOException {
        this.delegate.flush();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }
}

