/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.expression.RequiredValueException;
import org.mule.expression.MapPayloadExpressionEvaluator;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class MapPayloadExpressionEvaluatorTestCase
extends AbstractMuleTestCase {
    private MuleContext muleContext = (MuleContext)Mockito.mock(MuleContext.class);
    private Map<String, String> messageProperties = new HashMap<String, String>(3);
    private MapPayloadExpressionEvaluator evaluator = new MapPayloadExpressionEvaluator();
    private MuleMessage message;

    @Before
    public void createMessagePropertiesAndMuleMessage() throws Exception {
        this.messageProperties.put("foo", "moo");
        this.messageProperties.put("bar", "mar");
        this.messageProperties.put("ba?z", "maz");
        this.message = new DefaultMuleMessage(this.messageProperties, this.muleContext);
    }

    @Test
    public void requiredKeyWithExistingValueShouldReturnValue() {
        Object result = this.evaluator.evaluate("foo", this.message);
        Assert.assertEquals((Object)"moo", (Object)result);
    }

    @Test
    public void requiredKeyWithOptionalityMarkerInlineAndExistingValueShouldReturnValue() {
        Object result = this.evaluator.evaluate("ba?z", this.message);
        Assert.assertEquals((Object)"maz", (Object)result);
    }

    @Test(expected=RequiredValueException.class)
    public void requireKeyWithMissingValueShouldFail() {
        this.evaluator.evaluate("nonexisting", this.message);
    }

    @Test
    public void optionalKeyWithExistingValueShouldReturnValue() {
        Object result = this.evaluator.evaluate("bar?", this.message);
        Assert.assertEquals((Object)"mar", (Object)result);
    }

    @Test
    public void optionalKeyWithMissingValueShouldReturnNull() {
        Object result = this.evaluator.evaluate("nonexistent?", this.message);
        Assert.assertNull((Object)result);
    }

    @Test
    public void multipleExpressionsShouldReturnMultipleValues() throws Exception {
        Object result = this.evaluator.evaluate("foo,bar?,ba?z,fool?", this.message);
        Assert.assertTrue((boolean)(result instanceof Map));
        Map map = (Map)result;
        Assert.assertEquals((long)3L, (long)map.size());
        Assert.assertEquals((Object)"moo", map.get("foo"));
        Assert.assertEquals((Object)"mar", map.get("bar"));
        Assert.assertEquals((Object)"maz", map.get("ba?z"));
        Assert.assertNull(map.get("fool?"));
    }
}

