/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.service.Service;
import org.mule.api.store.ObjectStoreException;
import org.mule.routing.AbstractAggregator;
import org.mule.routing.AggregationException;
import org.mule.routing.EventGroup;
import org.mule.routing.correlation.EventCorrelatorCallback;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.fruit.Apple;

public class AggregatorTestCase
extends AbstractMuleContextTestCase {
    public AggregatorTestCase() {
        this.setStartContext(true);
    }

    @Test
    public void testMessageAggregator() throws Exception {
        Service testService = AggregatorTestCase.getTestService("test", Apple.class);
        MuleSession session = AggregatorTestCase.getTestSession(testService, muleContext);
        TestEventAggregator router = new TestEventAggregator(3);
        router.setMuleContext(muleContext);
        router.setFlowConstruct((FlowConstruct)testService);
        router.initialise();
        DefaultMuleMessage message1 = new DefaultMuleMessage((Object)"test event A", muleContext);
        DefaultMuleMessage message2 = new DefaultMuleMessage((Object)"test event B", muleContext);
        DefaultMuleMessage message3 = new DefaultMuleMessage((Object)"test event C", muleContext);
        message1.setCorrelationId(message1.getUniqueId());
        message2.setCorrelationId(message1.getUniqueId());
        message3.setCorrelationId(message1.getUniqueId());
        InboundEndpoint endpoint = MuleTestUtils.getTestInboundEndpoint(MessageExchangePattern.ONE_WAY, muleContext);
        DefaultMuleEvent event1 = new DefaultMuleEvent((MuleMessage)message1, endpoint, (FlowConstruct)testService, session);
        DefaultMuleEvent event2 = new DefaultMuleEvent((MuleMessage)message2, endpoint, (FlowConstruct)testService, session);
        DefaultMuleEvent event3 = new DefaultMuleEvent((MuleMessage)message3, endpoint, (FlowConstruct)testService, session);
        Assert.assertNull((Object)router.process((MuleEvent)event1));
        Assert.assertNull((Object)router.process((MuleEvent)event2));
        MuleEvent result = router.process((MuleEvent)event3);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.getMessageAsString().contains("test event A"));
        Assert.assertTrue((boolean)result.getMessageAsString().contains("test event B"));
        Assert.assertTrue((boolean)result.getMessageAsString().contains("test event C"));
        Assert.assertTrue((boolean)result.getMessageAsString().matches("test event [A,B,C] test event [A,B,C] test event [A,B,C] "));
    }

    public static class TestEventAggregator
    extends AbstractAggregator {
        protected final int eventThreshold;
        protected int eventCount = 0;

        public TestEventAggregator(int eventThreshold) {
            this.eventThreshold = eventThreshold;
        }

        protected EventCorrelatorCallback getCorrelatorCallback(final MuleContext muleContext) {
            return new EventCorrelatorCallback(){

                public boolean shouldAggregateEvents(EventGroup events) {
                    ++TestEventAggregator.this.eventCount;
                    if (TestEventAggregator.this.eventCount == TestEventAggregator.this.eventThreshold) {
                        TestEventAggregator.this.eventCount = 0;
                        return true;
                    }
                    return false;
                }

                public EventGroup createEventGroup(MuleEvent event, Object groupId) {
                    return new EventGroup(groupId, muleContext, TestEventAggregator.this.eventThreshold, false, this.getClass().getName());
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public MuleEvent aggregateEvents(EventGroup events) throws AggregationException {
                    if (events.size() != TestEventAggregator.this.eventThreshold) {
                        throw new IllegalStateException("eventThreshold not yet reached?");
                    }
                    StringBuffer newPayload = new StringBuffer(80);
                    try {
                        for (MuleEvent event : events) {
                            try {
                                newPayload.append(event.getMessageAsString()).append(" ");
                            }
                            catch (MuleException e) {
                                throw new AggregationException(events, TestEventAggregator.this.next, (Throwable)e);
                                return new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)newPayload.toString(), muleContext), events.getMessageCollectionEvent());
                            }
                        }
                    }
                    catch (ObjectStoreException e) {
                        throw new AggregationException(events, TestEventAggregator.this.next, (Throwable)e);
                    }
                }
            };
        }
    }
}

