/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMessageCollection;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessageCollection;
import org.mule.api.MuleSession;
import org.mule.routing.DefaultRouterResultsHandler;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class DefaultRouterResultsHandlerTestCase
extends AbstractMuleContextTestCase {
    @Test
    public void testAggregateSingleResult() throws Exception {
        MuleEvent event = DefaultRouterResultsHandlerTestCase.getTestEvent("previuos");
        MuleEvent event1 = DefaultRouterResultsHandlerTestCase.getTestEvent("foo1");
        event.getSession().setProperty("key", (Serializable)((Object)"value"));
        event1.getSession().setProperty("key", (Serializable)((Object)"valueNEW"));
        event1.getSession().setProperty("key1", (Serializable)((Object)"value1"));
        DefaultRouterResultsHandler resultsHandler = new DefaultRouterResultsHandler();
        MuleEvent result = resultsHandler.aggregateResults(Collections.singletonList(event1), event, muleContext);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals(DefaultMuleMessage.class, result.getMessage().getClass());
        Assert.assertSame((Object)event1, (Object)result);
        Assert.assertEquals((Object)event1.getMessage(), (Object)result.getMessage());
        Assert.assertEquals((Object)"valueNEW", (Object)result.getSession().getProperty("key"));
        Assert.assertEquals((Object)"value1", (Object)result.getSession().getProperty("key1"));
    }

    @Test
    public void testAggregateMultipleResults() throws Exception {
        MuleEvent event = DefaultRouterResultsHandlerTestCase.getTestEvent("previuos");
        MuleSession session = event.getSession();
        MuleEvent event1 = DefaultRouterResultsHandlerTestCase.getTestEvent((Object)"foo1", session);
        MuleEvent event2 = DefaultRouterResultsHandlerTestCase.getTestEvent((Object)"foo2", session);
        MuleEvent event3 = DefaultRouterResultsHandlerTestCase.getTestEvent("foo3");
        event.getSession().setProperty("key", (Serializable)((Object)"value"));
        event1.getSession().setProperty("key1", (Serializable)((Object)"value1"));
        event1.getSession().setProperty("key2", (Serializable)((Object)"value2"));
        event2.getSession().setProperty("KEY2", (Serializable)((Object)"value2NEW"));
        event2.getSession().setProperty("key3", (Serializable)((Object)"value3"));
        event3.getSession().setProperty("key4", (Serializable)((Object)"value4"));
        MuleEvent event4 = DefaultRouterResultsHandlerTestCase.getTestEvent((Object)"foo5", event.getSession());
        ArrayList<MuleEvent> eventList = new ArrayList<MuleEvent>();
        eventList.add(event1);
        eventList.add(event2);
        eventList.add(event3);
        eventList.add(event4);
        DefaultRouterResultsHandler resultsHandler = new DefaultRouterResultsHandler();
        MuleEvent result = resultsHandler.aggregateResults(eventList, event, muleContext);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals(DefaultMessageCollection.class, result.getMessage().getClass());
        Assert.assertEquals((long)4L, (long)((MuleMessageCollection)result.getMessage()).size());
        Assert.assertEquals((Object)event1.getMessage(), (Object)((MuleMessageCollection)result.getMessage()).getMessage(0));
        Assert.assertEquals((Object)event2.getMessage(), (Object)((MuleMessageCollection)result.getMessage()).getMessage(1));
        Assert.assertEquals((Object)event3.getMessage(), (Object)((MuleMessageCollection)result.getMessage()).getMessage(2));
        Assert.assertEquals((Object)event4.getMessage(), (Object)((MuleMessageCollection)result.getMessage()).getMessage(3));
        Assert.assertEquals((Object)"value", (Object)result.getSession().getProperty("key"));
        Assert.assertEquals((Object)"value1", (Object)result.getSession().getProperty("key1"));
        Assert.assertEquals((Object)"value2NEW", (Object)result.getSession().getProperty("key2"));
        Assert.assertEquals((Object)"value3", (Object)result.getSession().getProperty("key3"));
        Assert.assertNull((Object)result.getSession().getProperty("key4"));
    }
}

