/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transaction;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.transaction.Transaction;
import org.mule.exception.DefaultMessagingExceptionStrategy;
import org.mule.routing.filters.WildcardFilter;
import org.mule.tck.testmodels.mule.TestTransaction;
import org.mule.transaction.TransactionCoordination;
import org.mule.transaction.TransactionTemplate;
import org.mule.transaction.TransactionTemplateFactory;
import org.mule.transaction.TransactionTemplateTestUtils;

@RunWith(value=MockitoJUnitRunner.class)
public class ErrorHandlingTransactionTemplateTestCase {
    private static final Object RETURN_VALUE = new Object();
    private MuleContext mockMuleContext = (MuleContext)Mockito.mock(MuleContext.class);
    @Mock
    private MessagingException mockMessagingException;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MuleEvent mockEvent;
    @Spy
    protected TestTransaction mockTransaction = new TestTransaction(this.mockMuleContext);

    @Before
    public void unbindTransaction() throws Exception {
        Transaction currentTransaction = TransactionCoordination.getInstance().getTransaction();
        if (currentTransaction != null) {
            TransactionCoordination.getInstance().unbindTransaction(currentTransaction);
        }
    }

    @Test
    public void testSuccessfulExecution() throws Exception {
        TransactionTemplate transactionTemplate = TransactionTemplateFactory.createExceptionHandlingTransactionTemplate((MuleContext)this.mockMuleContext);
        Object result = transactionTemplate.execute(TransactionTemplateTestUtils.getEmptyTransactionCallback(RETURN_VALUE));
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)RETURN_VALUE));
    }

    @Test
    public void testFailureException() throws Exception {
        TransactionTemplate transactionTemplate = TransactionTemplateFactory.createExceptionHandlingTransactionTemplate((MuleContext)this.mockMuleContext);
        MuleEvent mockResultEvent = (MuleEvent)Mockito.mock(MuleEvent.class);
        Mockito.when((Object)this.mockMessagingException.getEvent()).thenReturn((Object)this.mockEvent).thenReturn((Object)this.mockEvent).thenReturn((Object)mockResultEvent);
        Mockito.when((Object)this.mockEvent.getFlowConstruct().getExceptionListener().handleException((Exception)((Object)this.mockMessagingException), this.mockEvent)).thenReturn((Object)mockResultEvent);
        try {
            transactionTemplate.execute(TransactionTemplateTestUtils.getFailureTransactionCallback(this.mockMessagingException));
            Assert.fail((String)"MessagingException must be thrown");
        }
        catch (MessagingException e) {
            Assert.assertThat((Object)((Object)e), (Matcher)Is.is((Object)((Object)this.mockMessagingException)));
            ((MessagingException)((Object)Mockito.verify((Object)((Object)this.mockMessagingException)))).setProcessedEvent(mockResultEvent);
        }
    }

    @Test
    public void testTransactionIsRollbackOnExceptionByDefault() throws Exception {
        TransactionTemplate transactionTemplate = TransactionTemplateFactory.createExceptionHandlingTransactionTemplate((MuleContext)this.mockMuleContext);
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        this.configureExceptionListener(null, null);
        try {
            transactionTemplate.execute(TransactionTemplateTestUtils.getFailureTransactionCallback(this.mockMessagingException));
            Assert.fail((String)"MessagingException must be thrown");
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction)))).rollback();
    }

    @Test
    public void testTransactionIsCommitOnEveryException() throws Exception {
        TransactionTemplate transactionTemplate = TransactionTemplateFactory.createExceptionHandlingTransactionTemplate((MuleContext)this.mockMuleContext);
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        this.configureExceptionListener(null, "*");
        try {
            transactionTemplate.execute(TransactionTemplateTestUtils.getFailureTransactionCallback(this.mockMessagingException));
            Assert.fail((String)"MessagingException must be thrown");
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction)))).commit();
    }

    @Test
    public void testTransactionIsCommitOnMatcherRegexPatternException() throws Exception {
        TransactionTemplate transactionTemplate = TransactionTemplateFactory.createExceptionHandlingTransactionTemplate((MuleContext)this.mockMuleContext);
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        this.configureExceptionListener(null, "org.mule.ap*");
        try {
            transactionTemplate.execute(TransactionTemplateTestUtils.getFailureTransactionCallback(this.mockMessagingException));
            Assert.fail((String)"MessagingException must be thrown");
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction)))).commit();
    }

    @Test
    public void testTransactionIsCommitOnClassHierarchyPatternException() throws Exception {
        TransactionTemplate transactionTemplate = TransactionTemplateFactory.createExceptionHandlingTransactionTemplate((MuleContext)this.mockMuleContext);
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        this.configureExceptionListener(null, "org.mule.api.MuleException+");
        try {
            transactionTemplate.execute(TransactionTemplateTestUtils.getFailureTransactionCallback(this.mockMessagingException));
            Assert.fail((String)"MessagingException must be thrown");
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction)))).commit();
    }

    @Test
    public void testTransactionIsCommitOnClassExactlyPatternException() throws Exception {
        TransactionTemplate transactionTemplate = TransactionTemplateFactory.createExceptionHandlingTransactionTemplate((MuleContext)this.mockMuleContext);
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        this.configureExceptionListener(null, "org.mule.api.MessagingException");
        try {
            transactionTemplate.execute(TransactionTemplateTestUtils.getFailureTransactionCallback(new MessagingException(this.mockEvent, null)));
            Assert.fail((String)"MessagingException must be thrown");
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction)))).commit();
    }

    @Test
    public void testTransactionIsRollbackOnPatternAppliesToRollbackAndCommit() throws Exception {
        TransactionTemplate transactionTemplate = TransactionTemplateFactory.createExceptionHandlingTransactionTemplate((MuleContext)this.mockMuleContext);
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        this.configureExceptionListener("org.mule.api.MuleException+", "org.mule.api.MessagingException");
        try {
            transactionTemplate.execute(TransactionTemplateTestUtils.getFailureTransactionCallback(this.mockMessagingException));
            Assert.fail((String)"MessagingException must be thrown");
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction)))).rollback();
    }

    @Test
    public void testSuspendedTransactionResumedOnException() throws Exception {
        this.mockTransaction.setXA(true);
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        TransactionCoordination.getInstance().suspendCurrentTransaction();
        Assert.assertThat((Object)TransactionCoordination.getInstance().getTransaction(), (Matcher)IsNull.nullValue());
        this.configureExceptionListener(null, null);
        TransactionTemplate transactionTemplate = TransactionTemplateFactory.createExceptionHandlingTransactionTemplate((MuleContext)this.mockMuleContext);
        try {
            transactionTemplate.execute(TransactionTemplateTestUtils.getFailureTransactionCallback(this.mockMessagingException));
            Assert.fail((String)"MessagingException must be thrown");
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction)))).resume();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).rollback();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).commit();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).setRollbackOnly();
        Assert.assertThat((Object)((Object)((TestTransaction)TransactionCoordination.getInstance().getTransaction())), (Matcher)Is.is((Object)((Object)this.mockTransaction)));
    }

    @Test
    public void testSuspendedTransactionResumedAndNewTransactionResolvedOnException() throws Exception {
        this.mockTransaction.setXA(true);
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        TransactionCoordination.getInstance().suspendCurrentTransaction();
        Assert.assertThat((Object)TransactionCoordination.getInstance().getTransaction(), (Matcher)IsNull.nullValue());
        this.configureExceptionListener(null, null);
        TransactionTemplate transactionTemplate = TransactionTemplateFactory.createExceptionHandlingTransactionTemplate((MuleContext)this.mockMuleContext);
        Transaction mockNewTransaction = (Transaction)Mockito.spy((Object)((Object)new TestTransaction(this.mockMuleContext)));
        try {
            transactionTemplate.execute(TransactionTemplateTestUtils.getFailureTransactionCallbackStartsTransaction(this.mockMessagingException, mockNewTransaction));
            Assert.fail((String)"MessagingException must be thrown");
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction)))).resume();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).rollback();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).commit();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).setRollbackOnly();
        ((Transaction)Mockito.verify((Object)mockNewTransaction, (VerificationMode)VerificationModeFactory.times((int)1))).rollback();
        ((Transaction)Mockito.verify((Object)mockNewTransaction, (VerificationMode)VerificationModeFactory.times((int)0))).commit();
        ((Transaction)Mockito.verify((Object)mockNewTransaction, (VerificationMode)VerificationModeFactory.times((int)1))).setRollbackOnly();
        Assert.assertThat((Object)((Object)((TestTransaction)TransactionCoordination.getInstance().getTransaction())), (Matcher)Is.is((Object)((Object)this.mockTransaction)));
    }

    private void configureExceptionListener(final String rollbackFilter, final String commitFilter) {
        Mockito.when((Object)this.mockMessagingException.getEvent()).thenReturn((Object)this.mockEvent);
        Mockito.when((Object)this.mockEvent.getFlowConstruct().getExceptionListener().handleException((Exception)Matchers.any(MessagingException.class), (MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                DefaultMessagingExceptionStrategy defaultMessagingExceptionStrategy = new DefaultMessagingExceptionStrategy();
                if (rollbackFilter != null) {
                    defaultMessagingExceptionStrategy.setRollbackTxFilter(new WildcardFilter(rollbackFilter));
                }
                if (commitFilter != null) {
                    defaultMessagingExceptionStrategy.setCommitTxFilter(new WildcardFilter(commitFilter));
                }
                defaultMessagingExceptionStrategy.handleException((Exception)invocationOnMock.getArguments()[0], (MuleEvent)invocationOnMock.getArguments()[1]);
                return null;
            }
        });
    }
}

