/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transaction;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.transaction.ExternalTransactionAwareTransactionFactory;
import org.mule.api.transaction.Transaction;
import org.mule.api.transaction.TransactionConfig;
import org.mule.api.transaction.TransactionFactory;
import org.mule.exception.DefaultMessagingExceptionStrategy;
import org.mule.tck.testmodels.mule.TestTransaction;
import org.mule.tck.testmodels.mule.TestTransactionFactory;
import org.mule.transaction.MuleTransactionConfig;
import org.mule.transaction.NestedTransactionTemplateTestCase;
import org.mule.transaction.TransactionCoordination;
import org.mule.transaction.TransactionTemplate;
import org.mule.transaction.TransactionTemplateFactory;
import org.mule.transaction.TransactionTemplateTestUtils;

@RunWith(value=MockitoJUnitRunner.class)
public class MainTransactionalTemplateTestCase
extends NestedTransactionTemplateTestCase {
    @Test
    public void testActionNoneAndXaTxAndFailureInCallback() throws Exception {
        this.mockTransaction.setXA(true);
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        MuleTransactionConfig config = new MuleTransactionConfig(0);
        TransactionTemplate transactionTemplate = this.createTransactionalTemplate(config);
        MuleEvent mockExceptionListenerResultEvent = this.configureExceptionListenerCall();
        try {
            transactionTemplate.execute(TransactionTemplateTestUtils.getFailureTransactionCallback(this.mockMessagingException));
            Assert.fail((String)"MessagingException must be thrown");
        }
        catch (MessagingException e) {
            Assert.assertThat((Object)((Object)e), (Matcher)Is.is((Object)((Object)this.mockMessagingException)));
            ((MessagingException)((Object)Mockito.verify((Object)((Object)this.mockMessagingException)))).setProcessedEvent(mockExceptionListenerResultEvent);
        }
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction)))).suspend();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).commit();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).rollback();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction)))).resume();
    }

    @Test
    public void testActionAlwaysBeginAndSuspendXaTxAndFailureCallback() throws Exception {
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        this.mockTransaction.setXA(true);
        MuleTransactionConfig config = new MuleTransactionConfig(1);
        TransactionTemplate transactionTemplate = this.createTransactionalTemplate(config);
        config.setFactory((TransactionFactory)new TestTransactionFactory((Transaction)this.mockNewTransaction));
        MuleEvent exceptionListenerResult = this.configureExceptionListenerCall();
        try {
            transactionTemplate.execute(TransactionTemplateTestUtils.getFailureTransactionCallback(this.mockMessagingException));
        }
        catch (MessagingException e) {
            Assert.assertThat((Object)((Object)e), (Matcher)Is.is((Object)((Object)this.mockMessagingException)));
            Assert.assertThat((Object)e.getEvent(), (Matcher)Is.is((Object)exceptionListenerResult));
        }
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction)))).suspend();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).commit();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).rollback();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockNewTransaction)))).rollback();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction)))).resume();
        Assert.assertThat((Object)((Object)((TestTransaction)TransactionCoordination.getInstance().getTransaction())), (Matcher)Is.is((Object)((Object)this.mockTransaction)));
    }

    @Test
    public void testActionAlwaysJoinAndExternalTxAndFailureCallback() throws Exception {
        MuleTransactionConfig config = new MuleTransactionConfig(3);
        config.setInteractWithExternal(true);
        this.mockExternalTransactionFactory = (ExternalTransactionAwareTransactionFactory)Mockito.mock(ExternalTransactionAwareTransactionFactory.class);
        config.setFactory((TransactionFactory)this.mockExternalTransactionFactory);
        Mockito.when((Object)this.mockExternalTransactionFactory.joinExternalTransaction(this.mockMuleContext)).thenAnswer((Answer)new Answer<Transaction>(){

            public Transaction answer(InvocationOnMock invocationOnMock) throws Throwable {
                TransactionCoordination.getInstance().bindTransaction((Transaction)MainTransactionalTemplateTestCase.this.mockTransaction);
                return MainTransactionalTemplateTestCase.this.mockTransaction;
            }
        });
        TransactionTemplate transactionTemplate = this.createTransactionalTemplate(config);
        MuleEvent exceptionListenerResult = this.configureExceptionListenerCall();
        try {
            transactionTemplate.execute(TransactionTemplateTestUtils.getFailureTransactionCallback(this.mockMessagingException));
        }
        catch (MessagingException e) {
            Assert.assertThat((Object)((Object)e), (Matcher)Is.is((Object)((Object)this.mockMessagingException)));
            Assert.assertThat((Object)e.getEvent(), (Matcher)Is.is((Object)exceptionListenerResult));
        }
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).commit();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)1)))).rollback();
        Assert.assertThat((Object)TransactionCoordination.getInstance().getTransaction(), (Matcher)IsNull.nullValue());
    }

    @Override
    protected TransactionTemplate createTransactionalTemplate(MuleTransactionConfig config) {
        return TransactionTemplateFactory.createMainTransactionTemplate((TransactionConfig)config, (MuleContext)this.mockMuleContext);
    }

    private MuleEvent configureExceptionListenerCall() {
        final MuleEvent mockResultEvent = (MuleEvent)Mockito.mock(MuleEvent.class);
        Mockito.when((Object)this.mockMessagingException.getEvent()).thenReturn((Object)this.mockEvent).thenReturn((Object)this.mockEvent).thenReturn((Object)mockResultEvent);
        Mockito.when((Object)this.mockEvent.getFlowConstruct().getExceptionListener().handleException((Exception)((Object)this.mockMessagingException), this.mockEvent)).thenAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                new DefaultMessagingExceptionStrategy().handleException((Exception)invocationOnMock.getArguments()[0], (MuleEvent)invocationOnMock.getArguments()[1]);
                return mockResultEvent;
            }
        });
        return mockResultEvent;
    }
}

